package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.purchasingmanagement.vo.FreightsigndetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 采购运费签认单
 * 
 * @author generator
 * 
 */
public class FreightsignVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long contractId; // 合同主键
    private String contractName; // 合同名称
    private Long transportId; // 运输商主键
    private String transportName; // 运输商名称
    private BigDecimal bookTotalMoney; // 账面总额
    private BigDecimal receivablesMoney; // 收款金额
    private BigDecimal bookBalance; // 账面余额
    private BigDecimal signMoney; // 签认金额
    private BigDecimal signBalance; // 签认余额
    private Date signTime; // 签认日期
    private Date failureTime; // 失效日期
    private Integer signStatus; // 签认状态 0-已签认,1-未签认
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号
    private Integer isSign; // 是否签认: 0是1否
    private Integer isRefund; // 是否退款: 0是1否
    private Integer isDistribution; // 是否分配: 0是1否
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM", timezone = "GMT+8")
    private Date signMonth; // 签认月份
    
    private List<FreightsigndetailVO> freightsigndetailList = new ArrayList<>(); // 采购运费签认单
    @ReferSerialTransfer(referCode="PurchaseContractRef")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode="ShippersRef")
    public Long getTransportId() {
        return transportId;
    }
    @ReferDeserialTransfer
    public void setTransportId(Long transportId) {
        this.transportId = transportId;
    }
    public String getTransportName() {
        return transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }
    public BigDecimal getBookTotalMoney() {
        return bookTotalMoney;
    }

    public void setBookTotalMoney(BigDecimal bookTotalMoney) {
        this.bookTotalMoney = bookTotalMoney;
    }
    public BigDecimal getReceivablesMoney() {
        return receivablesMoney;
    }

    public void setReceivablesMoney(BigDecimal receivablesMoney) {
        this.receivablesMoney = receivablesMoney;
    }
    public BigDecimal getBookBalance() {
        return bookBalance;
    }

    public void setBookBalance(BigDecimal bookBalance) {
        this.bookBalance = bookBalance;
    }
    public BigDecimal getSignMoney() {
        return signMoney;
    }

    public void setSignMoney(BigDecimal signMoney) {
        this.signMoney = signMoney;
    }
    public BigDecimal getSignBalance() {
        return signBalance;
    }

    public void setSignBalance(BigDecimal signBalance) {
        this.signBalance = signBalance;
    }
    public Date getSignTime() {
        return signTime;
    }

    public void setSignTime(Date signTime) {
        this.signTime = signTime;
    }
    public Date getFailureTime() {
        return failureTime;
    }

    public void setFailureTime(Date failureTime) {
        this.failureTime = failureTime;
    }
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getIsSign() {
        return isSign;
    }

    public void setIsSign(Integer isSign) {
        this.isSign = isSign;
    }
    public Integer getIsRefund() {
        return isRefund;
    }

    public void setIsRefund(Integer isRefund) {
        this.isRefund = isRefund;
    }
    public Integer getIsDistribution() {
        return isDistribution;
    }

    public void setIsDistribution(Integer isDistribution) {
        this.isDistribution = isDistribution;
    }
    public Date getSignMonth() {
        return signMonth;
    }

    public void setSignMonth(Date signMonth) {
        this.signMonth = signMonth;
    }
    
     public List<FreightsigndetailVO> getFreightsigndetailList() {
        return freightsigndetailList;
     }

     public void setFreightsigndetailList(List<FreightsigndetailVO> freightsigndetailList) {
        this.freightsigndetailList = freightsigndetailList;
     }
}
