package com.ejianc.business.purchasingmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.purchasingmanagement.bean.FreightsigndetailEntity;
/**
 * 采购运费签认单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_purchasingmanagement_freightsign")
public class FreightsignEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="transport_id")
    private Long transportId; // 运输商主键
    @TableField(value="transport_name")
    private String transportName; // 运输商名称
    @TableField(value="book_total_money")
    private BigDecimal bookTotalMoney; // 账面总额
    @TableField(value="receivables_money")
    private BigDecimal receivablesMoney; // 收款金额
    @TableField(value="book_balance")
    private BigDecimal bookBalance; // 账面余额
    @TableField(value="sign_money")
    private BigDecimal signMoney; // 签认金额
    @TableField(value="sign_balance")
    private BigDecimal signBalance; // 签认余额
    @TableField(value="sign_time")
    private Date signTime; // 签认日期
    @TableField(value="failure_time")
    private Date failureTime; // 失效日期
    @TableField(value="sign_status")
    private Integer signStatus; // 签认状态 0-已签认,1-未签认
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="is_Sign")
    private Integer isSign; // 是否签认: 0是1否
    @TableField(value="is_refund")
    private Integer isRefund; // 是否退款: 0是1否
    @TableField(value="is_distribution")
    private Integer isDistribution; // 是否分配: 0是1否
    @TableField(value="sign_month")
    private Date signMonth; // 签认月份
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="freightsigndetailService",pidName = "mid")//此处有pid="xxx"，默认值pid="pid"
    private List<FreightsigndetailEntity> freightsigndetailList = new ArrayList<>(); // 采购运费签认单
    

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getTransportId() {
        return transportId;
    }

    public void setTransportId(Long transportId) {
        this.transportId = transportId;
    }
    public String getTransportName() {
        return transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }
    public BigDecimal getBookTotalMoney() {
        return bookTotalMoney;
    }

    public void setBookTotalMoney(BigDecimal bookTotalMoney) {
        this.bookTotalMoney = bookTotalMoney;
    }
    public BigDecimal getReceivablesMoney() {
        return receivablesMoney;
    }

    public void setReceivablesMoney(BigDecimal receivablesMoney) {
        this.receivablesMoney = receivablesMoney;
    }
    public BigDecimal getBookBalance() {
        return bookBalance;
    }

    public void setBookBalance(BigDecimal bookBalance) {
        this.bookBalance = bookBalance;
    }
    public BigDecimal getSignMoney() {
        return signMoney;
    }

    public void setSignMoney(BigDecimal signMoney) {
        this.signMoney = signMoney;
    }
    public BigDecimal getSignBalance() {
        return signBalance;
    }

    public void setSignBalance(BigDecimal signBalance) {
        this.signBalance = signBalance;
    }
    public Date getSignTime() {
        return signTime;
    }

    public void setSignTime(Date signTime) {
        this.signTime = signTime;
    }
    public Date getFailureTime() {
        return failureTime;
    }

    public void setFailureTime(Date failureTime) {
        this.failureTime = failureTime;
    }
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getIsSign() {
        return isSign;
    }

    public void setIsSign(Integer isSign) {
        this.isSign = isSign;
    }
    public Integer getIsRefund() {
        return isRefund;
    }

    public void setIsRefund(Integer isRefund) {
        this.isRefund = isRefund;
    }
    public Integer getIsDistribution() {
        return isDistribution;
    }

    public void setIsDistribution(Integer isDistribution) {
        this.isDistribution = isDistribution;
    }
    public Date getSignMonth() {
        return signMonth;
    }

    public void setSignMonth(Date signMonth) {
        this.signMonth = signMonth;
    }
    
    public List<FreightsigndetailEntity> getFreightsigndetailList() {
        return freightsigndetailList;
    }

    public void setFreightsigndetailList(List<FreightsigndetailEntity> freightsigndetailList) {
        this.freightsigndetailList = freightsigndetailList;
    }
}
