package com.ejianc.business.purchasingmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.purchasingmanagement.bean.PurchasecontractdetailEntity;
/**
 * 采购合同
 * 
 * @author generator
 * 
 */
 @TableName("ejc_purchasingmanagement_purchasecontract")
public class PurchaseContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @TableField(value="name")
    private String name ;  // 合同名称
    @TableField(value="supplierinfo_id")
    private Long supplierinfoId; // 供应商基本档案主键
    @TableField(value="supplierinfo_name")
    private String supplierinfoName; // 供应商基本档案名称
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="contact_id")
    private Long contactId; // 联系人主键
    @TableField(value="contact_name")
    private String contactName;  //联系人姓名
    @TableField(value="contact_phone")
    private String contactPhone; // 联系人电话
    @TableField(value="start_date")
    private Date startDate; // 开始日期
    @TableField(value="end_date")
    private Date endDate; // 结束日期
    @TableField(value="counting_method")
    private Integer countingMethod; // 计数方式：1:收货数计 0:发货数计
    @TableField(value="contract")
    private Integer contract; // 合同方式：1:采购合同 0:销售合同
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="contract_types")
    private Long contractTypes; // 合同类型ID
    @TableField(value="contract_types_name")
    private String  contractTypesName; // 合同类型名称
    @TableField(value="stage")
    private Integer stage;//是否过期 0 未过期 /  1 已过期
    @TableField(value="contract_quantity")
    private BigDecimal contractQuantity; // 合同数量
    @TableField(value="contract_amount")
    private BigDecimal contractAmount; // 合同金额
    @TableField(value="receipt_quantity")
    private BigDecimal receiptQuantity; // 收货数量
    @TableField(value="receipt_amount")
    private BigDecimal receiptAmount; // 收货金额
    @TableField(value="shipping_amount")
    private BigDecimal shippingAmount; // 运费金额
    @TableField(value="is_major_contracts")
    private Long isMajorContracts; // 是否属于重大合同
    @TableField(value="transporter_id")
    private Long transporterId; // 运输商主键
    @TableField(value="transporter_name")
    private String transporterName; // 运输商名称
    @TableField(value="is_terminate")
    private Integer isTerminate;//是否终止
    @TableField(value="change_state")
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    @TableField(value="change_id")
    private Long changeId; // 变更单据id


    @TableField(exist=false)
    @SubEntity(serviceName="purchasecontractdetailService" , pidName="purchasecontractId")//此处有pid="xxx"，默认值pid="pid"
    private List<PurchasecontractdetailEntity> purchasecontractdetailList = new ArrayList<>(); // 采购合同明细

    public void setContractTypes(Long contractTypes) {
        this.contractTypes = contractTypes;
    }

    public String getContractTypesName() {
        return contractTypesName;
    }

    public void setContractTypesName(String contractTypesName) {
        this.contractTypesName = contractTypesName;
    }

    public BigDecimal getShippingAmount() {
        return shippingAmount;
    }

    public void setShippingAmount(BigDecimal shippingAmount) {
        this.shippingAmount = shippingAmount;
    }

    public BigDecimal getContractQuantity() {
        return contractQuantity;
    }

    public void setContractQuantity(BigDecimal contractQuantity) {
        this.contractQuantity = contractQuantity;
    }

    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }

    public BigDecimal getReceiptQuantity() {
        return receiptQuantity;
    }

    public void setReceiptQuantity(BigDecimal receiptQuantity) {
        this.receiptQuantity = receiptQuantity;
    }

    public BigDecimal getReceiptAmount() {
        return receiptAmount;
    }

    public void setReceiptAmount(BigDecimal receiptAmount) {
        this.receiptAmount = receiptAmount;
    }

    public Integer getStage() {
        return stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }

    public Long getContractTypes() {
        return contractTypes;
    }

    public String getContactName() {
        return contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
   // @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }
   // @ReferDeserialTransfer
    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getContactId() {
        return contactId;
    }

    public void setContactId(Long contactId) {
        this.contactId = contactId;
    }
    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Integer getCountingMethod() {
        return countingMethod;
    }

    public void setCountingMethod(Integer countingMethod) {
        this.countingMethod = countingMethod;
    }
    public Integer getContract() {
        return contract;
    }

    public void setContract(Integer contract) {
        this.contract = contract;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
    public List<PurchasecontractdetailEntity> getPurchasecontractdetailList() {
        return purchasecontractdetailList;
    }

    public void setPurchasecontractdetailList(List<PurchasecontractdetailEntity> purchasecontractdetailList) {
        this.purchasecontractdetailList = purchasecontractdetailList;
    }

    public Long getIsMajorContracts() {
        return isMajorContracts;
    }

    public void setIsMajorContracts(Long isMajorContracts) {
        this.isMajorContracts = isMajorContracts;
    }

    public Long getTransporterId() {
        return transporterId;
    }

    public void setTransporterId(Long transporterId) {
        this.transporterId = transporterId;
    }

    public String getTransporterName() {
        return transporterName;
    }

    public void setTransporterName(String transporterName) {
        this.transporterName = transporterName;
    }
    public Integer getIsTerminate() {
        return isTerminate;
    }

    public void setIsTerminate(Integer isTerminate) {
        this.isTerminate = isTerminate;
    }

    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
}
