package com.ejianc.business.purchasingmanagement.change.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.purchasingmanagement.change.vo.ChangeContractdetailVO;
import com.ejianc.business.purchasingmanagement.record.vo.RecordPurchasecontractVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 采购合同变更表
 * 
 * @author generator
 * 
 */
public class ChangePurchasecontractVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long supplierinfoId; // 供应商基本档案主键
    private String supplierinfoName; // 供应商基本档案名称
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private Long contactId; // 联系人主键
    private String contactPhone; // 联系人电话
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 结束日期
    private Integer countingMethod; // 计数方式：1:收货数计 0:发货数计
    private Integer contract; // 合同方式：1:采购合同 0:销售合同
    private String remark; // 备注
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private String billCode; // 单据编号
    private String name; // 合同名称
    private String contactName; // 联系人姓名
    private Long contractTypes; // 合同类型
    private Integer stage; // 是否过期 0 未过期 /  1 已过期
    private BigDecimal contractQuantity; // 合同数量
    private BigDecimal contractAmount; // 合同金额
    private BigDecimal receiptQuantity; // 收货数量
    private BigDecimal receiptAmount; // 收货金额
    private BigDecimal shippingAmount; // 运费金额
    private String contractTypesName; // 合同类型名称
    private Long isMajorContracts; // 是否属于重大合同
    private Long transporterId; // 运输商主键
    private String transporterName; // 运输商名称
    private Integer isTerminate; // 是否终止  1未终止  0未终止
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private Date effectDate; // 生效时间
    private String changeReason; // 变更原因
    private Long originalId; // 原始单据id
    
    private List<ChangeContractdetailVO> changeContractdetailList = new ArrayList<>(); // 采购合同变更子表
    private List<RecordPurchasecontractVO> recordPurchasecontractList = new ArrayList<>(); // 采购合同变更记录表

    @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }

    @ReferDeserialTransfer
    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="SupplierlinkerRef")
    public Long getContactId() {
        return contactId;
    }

    @ReferDeserialTransfer
    public void setContactId(Long contactId) {
        this.contactId = contactId;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Integer getCountingMethod() {
        return countingMethod;
    }

    public void setCountingMethod(Integer countingMethod) {
        this.countingMethod = countingMethod;
    }
    public Integer getContract() {
        return contract;
    }

    public void setContract(Integer contract) {
        this.contract = contract;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getContactName() {
        return contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }
    @ReferSerialTransfer(referCode="MaterialCategoryRef")
    public Long getContractTypes() {
        return contractTypes;
    }

    @ReferDeserialTransfer
    public void setContractTypes(Long contractTypes) {
        this.contractTypes = contractTypes;
    }
    public Integer getStage() {
        return stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }
    public BigDecimal getContractQuantity() {
        return contractQuantity;
    }

    public void setContractQuantity(BigDecimal contractQuantity) {
        this.contractQuantity = contractQuantity;
    }
    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }
    public BigDecimal getReceiptQuantity() {
        return receiptQuantity;
    }

    public void setReceiptQuantity(BigDecimal receiptQuantity) {
        this.receiptQuantity = receiptQuantity;
    }
    public BigDecimal getReceiptAmount() {
        return receiptAmount;
    }

    public void setReceiptAmount(BigDecimal receiptAmount) {
        this.receiptAmount = receiptAmount;
    }
    public BigDecimal getShippingAmount() {
        return shippingAmount;
    }

    public void setShippingAmount(BigDecimal shippingAmount) {
        this.shippingAmount = shippingAmount;
    }
    public String getContractTypesName() {
        return contractTypesName;
    }

    public void setContractTypesName(String contractTypesName) {
        this.contractTypesName = contractTypesName;
    }
    public Long getIsMajorContracts() {
        return isMajorContracts;
    }

    public void setIsMajorContracts(Long isMajorContracts) {
        this.isMajorContracts = isMajorContracts;
    }
    public Long getTransporterId() {
        return transporterId;
    }

    public void setTransporterId(Long transporterId) {
        this.transporterId = transporterId;
    }
    public String getTransporterName() {
        return transporterName;
    }

    public void setTransporterName(String transporterName) {
        this.transporterName = transporterName;
    }
    public Integer getIsTerminate() {
        return isTerminate;
    }

    public void setIsTerminate(Integer isTerminate) {
        this.isTerminate = isTerminate;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    
     public List<ChangeContractdetailVO> getChangeContractdetailList() {
        return changeContractdetailList;
     }

     public void setChangeContractdetailList(List<ChangeContractdetailVO> changeContractdetailList) {
        this.changeContractdetailList = changeContractdetailList;
     }
     public List<RecordPurchasecontractVO> getRecordPurchasecontractList() {
        return recordPurchasecontractList;
     }

     public void setRecordPurchasecontractList(List<RecordPurchasecontractVO> recordPurchasecontractList) {
        this.recordPurchasecontractList = recordPurchasecontractList;
     }

    public Long getOriginalId() {
        return originalId;
    }

    public void setOriginalId(Long originalId) {
        this.originalId = originalId;
    }
}
