package com.ejianc.business.purchasingmanagement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.base.bases.vo.SettlementPerioddetailVO;
import com.ejianc.business.purchasingmanagement.bean.MaterialacceptanceEntity;
import com.ejianc.business.purchasingmanagement.bean.TransporterpaymentEntity;
import com.ejianc.business.purchasingmanagement.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.purchasingmanagement.bean.TransportationacceptanceEntity;
import com.ejianc.business.purchasingmanagement.service.ITransportationacceptanceService;

/**
 * 采购运输验收
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("transportationacceptance")
public class TransportationacceptanceController implements Serializable {
	private static final long serialVersionUID = 1L;



    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Qualifier("com.ejianc.business.base.bases.api.BaseApi")
    @Autowired
    private BaseApi baseApi;
    @Autowired
    private ITransportationacceptanceService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TransportationacceptanceVO> saveOrUpdate(@RequestBody TransportationacceptanceVO saveOrUpdateVO) {
    	TransportationacceptanceEntity entity = BeanMapper.map(saveOrUpdateVO, TransportationacceptanceEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
               // entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setStatus(1);
    	service.saveOrUpdate(entity, false);
    	TransportationacceptanceVO vo = BeanMapper.map(entity, TransportationacceptanceVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TransportationacceptanceVO> queryDetail(Long id) {
    	TransportationacceptanceEntity entity = service.selectById(id);
    	TransportationacceptanceVO vo = BeanMapper.map(entity, TransportationacceptanceVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TransportationacceptanceVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (TransportationacceptanceVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(TransportationacceptanceVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TransportationacceptanceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("shippersName");
        fuzzyFields.add("purchasecontractBillCode");
        fuzzyFields.add("purchasecontractMaterialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<TransportationacceptanceEntity> page = service.queryPage(param,false);
        IPage<TransportationacceptanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TransportationacceptanceVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TransportationacceptanceEntity> list = service.queryList(param);
        List<TransportationacceptanceVO> vo = BeanMapper.mapList(list,TransportationacceptanceVO.class);
        for(TransportationacceptanceVO TransportationacceptanceVO : vo){
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            //materialacceptanceVO.setAcceptanceDate(DateUtil.DoubleToDate(Double.valueOf(sdf.format(materialacceptanceVO.getAcceptanceDate()))));
            TransportationacceptanceVO.setAcceptanceDates(sdf.format(TransportationacceptanceVO.getAcceptanceDate()));
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vo);
        ExcelExport.getInstance().export("Transportationacceptance-export.xlsx", beans, response);
    }

        /**
         * @Description 参照
         * @param param
         * @Return void
         */
    @RequestMapping(value = "/refTransportationacceptanceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TransportationacceptanceVO>> refTransportationacceptanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TransportationacceptanceEntity> page = service.queryPage(param,false);
        IPage<TransportationacceptanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TransportationacceptanceVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     *
     */
    @RequestMapping(value = "/transportationacceptancelist", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TransporterpaymentdetailVO>> receivableslist(@RequestBody QueryParam param) {
        QueryWrapper<TransportationacceptanceEntity> queryWrapper = new QueryWrapper<>();
        if(param.getParams().get("shippers_id").getValue() != null){
            //param.getParams().remove("customer_name");
            queryWrapper.eq("shippers_id",param.getParams().get("shippers_id").getValue());
        }
        if(param.getParams().get("org_Id").getValue() != null){
            //param.getParams().remove("customer_name");
            queryWrapper.eq("org_Id",param.getParams().get("org_Id").getValue());
        }
        queryWrapper.eq("is_sign",0);
        queryWrapper.ne("amount_not_paid",new BigDecimal(0.00000000));
        //  queryWrapper.ne("uncollected_moeny",new BigDecimal(0.00000000));
        List<TransportationacceptanceEntity> list = service.list(queryWrapper);
        List<TransporterpaymentdetailVO> transportationacceptanceVOS = new ArrayList<>();
        for ( TransportationacceptanceEntity temp : list ) {
            TransporterpaymentdetailVO vo = new TransporterpaymentdetailVO();
            vo.setId(temp.getId());
            vo.setMaterialId(temp.getPurchasecontractdetailId());
            vo.setMaterialName(temp.getPurchasecontractMaterialName());
            vo.setTransportationacceptanceId(temp.getId());//采购运输验收ID
            vo.setAcceptanceDate(temp.getAcceptanceDate());//验收日期
            vo.setShippingType(temp.getAcceptanceType());//运费方式
            vo.setAmount(temp.getMeetMoney());//金额
            vo.setReceivableMoney(temp.getMeetMoney());//应收金额
            if(temp.getAmountNotPaid()!=null){
                vo.setUncollectedMoney(temp.getAmountNotPaid());
            }else{
                vo.setUncollectedMoney(temp.getTotalAmount());
            }
            //其他单已付金额
            if(temp.getAmountPaid()!=null){
                vo.setOtherReceivedMoney(temp.getAmountPaid());
            }else{
                vo.setOtherReceivedMoney(new BigDecimal(0.0));
            }

            vo.setReceivedMoney(new BigDecimal(0.00));//本单已付金额
            vo.setDistributionMoney(new BigDecimal(0.00));//分配金额
            vo.setBillCode(temp.getBillCode());
            transportationacceptanceVOS.add(vo);
        }
        return CommonResponse.success("查询列表数据成功！",transportationacceptanceVOS);

    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     *
     */
    @RequestMapping(value = "/supplierinvoicedetialist", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ShippersinvoicedetialVO>> supplierinvoicedetialist(@RequestBody QueryParam param) {
        QueryWrapper<TransportationacceptanceEntity> queryWrapper = new QueryWrapper<>();
        if(param.getParams().get("shippers_id").getValue() != null){
            //param.getParams().remove("customer_name");
            queryWrapper.eq("shippers_id",param.getParams().get("shippers_id").getValue());
        }
        if(param.getParams().get("org_Id").getValue() != null){
            //param.getParams().remove("customer_name");
            queryWrapper.eq("org_Id",param.getParams().get("org_Id").getValue());
        }
        queryWrapper.eq("is_sign",0);
        queryWrapper.ne("invoice_not_received",new BigDecimal(0.00000000));
        List<TransportationacceptanceEntity> list = service.list(queryWrapper);
        List<ShippersinvoicedetialVO> shippersinvoicedetialVOS = new ArrayList<>();
        for ( TransportationacceptanceEntity temp : list ) {
            ShippersinvoicedetialVO vo = new ShippersinvoicedetialVO();
            System.out.println(temp.getId());

            vo.setTransportationacceptanceId(temp.getId());//付款单主键
            vo.setMaterialId(temp.getPurchasecontractdetailId());
            vo.setMaterialName(temp.getPurchasecontractMaterialName());
            if(temp.getInvoiceNotReceived()!=null){
                vo.setUncollectedMoney(temp.getInvoiceNotReceived());
            }else{
                vo.setUncollectedMoney(temp.getTotalAmount());
            }
            vo.setReceivedMoney(new BigDecimal(0.0));
            if(temp.getInvoiceReceived()!=null){
                vo.setOtherReceivedMoney(temp.getInvoiceReceived());
            }else{
                vo.setOtherReceivedMoney(new BigDecimal(0.0));
            }
            vo.setReceivedMoney(new BigDecimal(0.0)); // 本单已开金额
            vo.setBillCode(temp.getBillCode());
            vo.setReceivablesDate(temp.getAcceptanceDate());
            vo.setInvoiceMoney(temp.getMeetMoney());
            vo.setId(temp.getId());

            shippersinvoicedetialVOS.add(vo);
        }
        return CommonResponse.success("查询列表数据成功！",shippersinvoicedetialVOS);

    }
    /**
     * @Description queryList 根据供应商和合同查询材料验收
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     *
     */
    @RequestMapping(value = "/getTransportationacceptanceList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<FreighttransferdetailVO>> getTransportationacceptanceList(@RequestBody QueryParam param) {

        QueryWrapper<TransportationacceptanceEntity> queryWrapper = new QueryWrapper<>();
        if(param.getParams().get("shippers_id").getValue() != null){
            queryWrapper.eq("shippers_id",param.getParams().get("shippers_id").getValue());
        }
        if(param.getParams().get("purchasecontract_id").getValue() != null){
            queryWrapper.eq("purchasecontract_id",param.getParams().get("purchasecontract_id").getValue());
        }
        List<TransportationacceptanceEntity> list = service.list(queryWrapper);
        List<FreighttransferdetailVO> freighttransferdetailVO = new ArrayList<>();
        for(TransportationacceptanceEntity entity : list){
            FreighttransferdetailVO vo = new FreighttransferdetailVO();
            vo.setId(entity.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setAcceptanceTime(entity.getAcceptanceDate());
            vo.setTransporterId(entity.getShippersId());
            vo.setTransporterName(entity.getShippersName());
            vo.setMaterialId(entity.getPurchasecontractdetailId());
            vo.setMaterialName(entity.getPurchasecontractMaterialName());
            vo.setTaxMoney(entity.getMeetMoney());
            vo.setDistributionMoney(new BigDecimal(0.00));
            vo.setUnpaidMoney(entity.getMeetMoney().subtract(entity.getAmountPaid()));
            vo.setMaterialacceptanceId(entity.getId());
            vo.setRowState("add");
            freighttransferdetailVO.add(vo);
        }
        return CommonResponse.success("查询列表数据成功！",freighttransferdetailVO);
    }
    /**
     * @Description queryList 根据供应商和合同和日期查询采购材料验收单，材料签认单子表使用
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     *
     */
    @RequestMapping(value = "/getFreightsignList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<FreightsigndetailVO>> getFreightsignList(@RequestBody QueryParam param) {

        QueryWrapper<TransportationacceptanceEntity> queryWrapper = new QueryWrapper<>();
        if(param.getParams().get("acceptance_date").getValue() != null){

            String orgid = param.getParams().get("orgId").getValue().toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date d = new Date(Long.valueOf(param.getParams().get("acceptance_date").getValue().toString()));
            String date = sdf.format(d);
            String starttime;
            String endtiem ;
            // 调用接口
            CommonResponse<SettlementPerioddetailVO> commonResponse = baseApi.querysettlement(date,orgid);
            if(commonResponse.getCode() == 0){
                Date start = commonResponse.getData().getStartDate();
                Date end = commonResponse.getData().getEndDate();
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                starttime = sd.format(start);
                endtiem = sd.format(end);
            }else{
                throw new BusinessException(commonResponse.getMsg());
            }
            queryWrapper.between("acceptance_date",starttime,endtiem);
        }
        if(param.getParams().get("shippers_id").getValue() != null){
            queryWrapper.eq("shippers_id",param.getParams().get("shippers_id").getValue());
        }
        if(param.getParams().get("purchasecontract_id").getValue() != null){
            queryWrapper.eq("purchasecontract_id",param.getParams().get("purchasecontract_id").getValue());
        }
        queryWrapper.eq("is_sign",1);
        List<TransportationacceptanceEntity> list = service.list(queryWrapper);
        List<FreightsigndetailVO> materialsigndetailVO = new ArrayList<>();
        for(TransportationacceptanceEntity entity : list){
            FreightsigndetailVO vo = new FreightsigndetailVO();
            vo.setId(entity.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setAcceptanceTime(entity.getAcceptanceDate());
            vo.setTransportId(entity.getShippersId());
            vo.setTransportName(entity.getShippersName());
            vo.setMaterialId(entity.getPurchasecontractdetailId());
            vo.setMaterialName(entity.getPurchasecontractMaterialName());
            vo.setTaxMoney(entity.getTotalAmount());
            vo.setAdjustedMoney(entity.getMeetMoney());
            vo.setDistributionMoney(entity.getAmountPaid());
            vo.setMaterialacceptanceId(entity.getId());
            vo.setRowState("add");
            materialsigndetailVO.add(vo);
        }
        return CommonResponse.success("查询列表数据成功！",materialsigndetailVO);
    }
}
