package com.ejianc.business.purchasingmanagement.controller.api;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.PurchasedetilEntity;
import com.ejianc.business.purchasingmanagement.bean.SupplierinformationEntity;
import com.ejianc.business.purchasingmanagement.service.ISupplierinformationService;
import com.ejianc.business.purchasingmanagement.vo.PurchasedetilVO;
import com.ejianc.business.purchasingmanagement.vo.RequestVO;
import com.ejianc.business.purchasingmanagement.vo.SupplierinformationVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/purchasingmanagement/accountInfoApi/")
public class AccountInfoApi {
    @Autowired
    private ISupplierinformationService service;
    /**
     * @Description  新增或者修改
     */
    @RequestMapping(value = "/accountInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierinformationVO> accountInfo(@RequestBody SupplierinformationVO supplierinformationVO) {

        QueryWrapper<SupplierinformationEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("username",supplierinformationVO.getUsername());
        queryWrapper.eq("password",supplierinformationVO.getPassword());
        queryWrapper.eq("org_id",supplierinformationVO.getOrgId());
        SupplierinformationEntity entity =   service.getOne(queryWrapper);
        SupplierinformationVO vo = BeanMapper.map(entity, SupplierinformationVO.class);
        return CommonResponse.success("查询成功！",vo);
    }

    @RequestMapping(value = "/accountDetil", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierinformationVO> accountDetil(@RequestBody RequestVO requestVO) {
        SupplierinformationEntity entity =   service.getById(requestVO.getId());
        SupplierinformationVO vo = BeanMapper.map(entity, SupplierinformationVO.class);
        return CommonResponse.success("查询成功！",vo);
    }


    /**
     * @Description  新增或者修改
     */
    @RequestMapping(value = "/accountUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierinformationVO> accountUpdate(@RequestBody SupplierinformationVO supplierinformationVO) {
        SupplierinformationEntity entity =   service.getById(supplierinformationVO.getId());
        entity.setPassword(supplierinformationVO.getPassword());
        entity.setUsername(supplierinformationVO.getUsername());
        service.updateById(entity);
        SupplierinformationVO vo = BeanMapper.map(entity, SupplierinformationVO.class);
        return CommonResponse.success("修改成功！",vo);
    }


}
