package com.ejianc.business.purchasingmanagement.controller.api;

import com.ejianc.business.purchasingmanagement.service.IMaterialacceptanceService;
import com.ejianc.business.purchasingmanagement.service.ITransportationacceptanceService;
import com.ejianc.business.purchasingmanagement.vo.AcceptanceVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/9/13
 * @description:查询采购相关的数据
 */
@RestController
@RequestMapping("/api/purchasingmanagement/selectApi/")
public class SelectApi {
    @Autowired
    IMaterialacceptanceService service;
    @Autowired
    ITransportationacceptanceService transportationacceptanceService;

    /**
     * 查询原材料收货信息
     * @param materialId 原材料id
     * @param acceptanceDate 验收日期
     * @return 原材料验收相关信息
     */
    @GetMapping(value = "querymaterialacceptance")
    @ResponseBody
    public CommonResponse<AcceptanceVO>  queryMaterialAcceptance(String materialId, String acceptanceDate,String orgId){
        AcceptanceVO materialAcceptanceVO =
                service.queryMaterialAcceptance(materialId, acceptanceDate,orgId);
        BigDecimal money = transportationacceptanceService.queryTransportationacceptanceMoney(materialId, acceptanceDate,orgId);
        materialAcceptanceVO.setAmount(materialAcceptanceVO.getAmount().add(money));
        return CommonResponse.success("查询原材料验收信息成功",materialAcceptanceVO);
    }
}
