package com.ejianc.business.purchasingmanagement.record.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 采购合同变更记录子表
 * 
 * @author generator
 * 
 */
public class RecordContractdetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long mid; // 采购合同主键
    private Long materialId; // 原材类品种主键
    private String materialName; // 原材类品种名称
    private BigDecimal price; // 单价
    private BigDecimal quantity; // 数量
    private Long manufacturerId; // 生产厂商主键
    private String manufacturerName; // 生产厂商名称
    private Integer freight; // 有无运费：1有运费 0无
    private BigDecimal distance; // 运距
    private Integer shippingMethod; // 运费计算方式
    private String remark; // 备注
    private BigDecimal materialTax; // 材料税
    private BigDecimal freightRate; // 运费税率
    private BigDecimal sjyfPrice; // 实际运费单价
    private BigDecimal kpyfPrice; // 开票运费单价
    private BigDecimal comprehensiveTaxRate; // 综合税率
    private BigDecimal combinedTax; // 结合税额
    private String dyyss; // 打印运输商
    private Long shippersId; // 运输商主键
    private String shippersName; // 运输商名称
    private BigDecimal amount; // 金额
    private BigDecimal deductionRate; // 扣率
    private BigDecimal money; // 不含税单价
    private BigDecimal decimalPoint; // 小数位数
    

    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }
    @ReferSerialTransfer(referCode="MaterialRef")
    public Long getMaterialId() {
        return materialId;
    }

    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }
    @ReferSerialTransfer(referCode="ManufacturerRef")
    public Long getManufacturerId() {
        return manufacturerId;
    }

    @ReferDeserialTransfer
    public void setManufacturerId(Long manufacturerId) {
        this.manufacturerId = manufacturerId;
    }
    public String getManufacturerName() {
        return manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }
    public Integer getFreight() {
        return freight;
    }

    public void setFreight(Integer freight) {
        this.freight = freight;
    }
    public BigDecimal getDistance() {
        return distance;
    }

    public void setDistance(BigDecimal distance) {
        this.distance = distance;
    }
    public Integer getShippingMethod() {
        return shippingMethod;
    }

    public void setShippingMethod(Integer shippingMethod) {
        this.shippingMethod = shippingMethod;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public BigDecimal getMaterialTax() {
        return materialTax;
    }

    public void setMaterialTax(BigDecimal materialTax) {
        this.materialTax = materialTax;
    }
    public BigDecimal getFreightRate() {
        return freightRate;
    }

    public void setFreightRate(BigDecimal freightRate) {
        this.freightRate = freightRate;
    }
    public BigDecimal getSjyfPrice() {
        return sjyfPrice;
    }

    public void setSjyfPrice(BigDecimal sjyfPrice) {
        this.sjyfPrice = sjyfPrice;
    }
    public BigDecimal getKpyfPrice() {
        return kpyfPrice;
    }

    public void setKpyfPrice(BigDecimal kpyfPrice) {
        this.kpyfPrice = kpyfPrice;
    }
    public BigDecimal getComprehensiveTaxRate() {
        return comprehensiveTaxRate;
    }

    public void setComprehensiveTaxRate(BigDecimal comprehensiveTaxRate) {
        this.comprehensiveTaxRate = comprehensiveTaxRate;
    }
    public BigDecimal getCombinedTax() {
        return combinedTax;
    }

    public void setCombinedTax(BigDecimal combinedTax) {
        this.combinedTax = combinedTax;
    }
    public String getDyyss() {
        return dyyss;
    }

    public void setDyyss(String dyyss) {
        this.dyyss = dyyss;
    }
    @ReferSerialTransfer(referCode="ShippersRef")
    public Long getShippersId() {
        return shippersId;
    }

    @ReferDeserialTransfer
    public void setShippersId(Long shippersId) {
        this.shippersId = shippersId;
    }
    public String getShippersName() {
        return shippersName;
    }

    public void setShippersName(String shippersName) {
        this.shippersName = shippersName;
    }
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    public BigDecimal getDeductionRate() {
        return deductionRate;
    }

    public void setDeductionRate(BigDecimal deductionRate) {
        this.deductionRate = deductionRate;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public BigDecimal getDecimalPoint() {
        return decimalPoint;
    }

    public void setDecimalPoint(BigDecimal decimalPoint) {
        this.decimalPoint = decimalPoint;
    }
    
}
