package com.ejianc.business.purchasingmanagement.service.impl;

import com.ejianc.business.purchasingmanagement.bean.*;
import com.ejianc.business.purchasingmanagement.service.*;
import com.ejianc.business.purchasingmanagement.vo.TransportationacceptanceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;

@Service("freighttransfer") 
public class FreighttransferBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IOrgApi iOrgApi;
	@Autowired
	private IFreighttransferService service;
	@Autowired
	private ITransportationacceptanceService transportationacceptanceService;
	@Autowired
	private IPurchaseContractService purchaseContractService;
	@Autowired
	private IPurchasecontractdetailService purchasecontractdetailService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("---------进来啦--------");
		FreighttransferEntity entity = service.selectById(billId);
		if(entity.getFreighttransferdetailList().size() > 0){
			logger.info("---------不为空--------");
			for(FreighttransferdetailEntity detailEntity : entity.getFreighttransferdetailList()){
				TransportationacceptanceEntity transportationacceptanceEntity = transportationacceptanceService.getById(detailEntity.getMaterialacceptanceId());
				transportationacceptanceEntity.setMeetMoney(detailEntity.getAdjustedMoney());
				logger.info("---------已修改--------");
				transportationacceptanceService.updateById(transportationacceptanceEntity);
			}
		}else{
			PurchasecontractdetailEntity purchasecontractdetailEntity = purchasecontractdetailService.getById(entity.getMaterialId());
			PurchaseContractEntity purchaseContractEntity = purchaseContractService.getById(entity.getContractId());
			TransportationacceptanceVO transportationacceptanceVO = new TransportationacceptanceVO();
			transportationacceptanceVO.setShippersId(entity.getTransporterId());
			transportationacceptanceVO.setShippersName(entity.getTransporterName());
			transportationacceptanceVO.setQuantity(new BigDecimal(0.00));


			transportationacceptanceVO.setTotalAmount(entity.getAdjustmentAmount());//含税金额
			BigDecimal tax = new BigDecimal(1.00).add(purchasecontractdetailEntity.getFreightRate());
			transportationacceptanceVO.setTax(entity.getAdjustmentAmount().divide(tax,2,BigDecimal.ROUND_HALF_UP));//税额
			transportationacceptanceVO.setMoney(entity.getAdjustmentAmount().subtract(transportationacceptanceVO.getTax()));//不含税金额
			transportationacceptanceVO.setPurchasecontractId(entity.getContractId());
			transportationacceptanceVO.setPurchasecontractBillCode(purchaseContractEntity.getBillCode());
			transportationacceptanceVO.setPurchasecontractdetailId(purchasecontractdetailEntity.getId());
			transportationacceptanceVO.setPurchasecontractMaterialName(purchasecontractdetailEntity.getMaterialName());
			transportationacceptanceVO.setAcceptanceDate(entity.getDate());
			transportationacceptanceVO.setOrgId(entity.getOrgId());
			transportationacceptanceVO.setOrgName(entity.getOrgName());

			transportationacceptanceVO.setMeetMoney(transportationacceptanceVO.getTotalAmount());
			transportationacceptanceVO.setAmountPaid(new BigDecimal(0.00));
			transportationacceptanceVO.setAmountNotPaid(transportationacceptanceVO.getTotalAmount());
			transportationacceptanceVO.setInvoiceReceived(new BigDecimal(0.00));
			transportationacceptanceVO.setInvoiceNotReceived(transportationacceptanceVO.getTotalAmount());
			transportationacceptanceVO.setIsSign(1);
			transportationacceptanceVO.setAcceptanceType(1);
			transportationacceptanceVO.setSalesreconciliationId(entity.getId());
			TransportationacceptanceEntity transportationacceptanceEntity = BeanMapper.map(transportationacceptanceVO, TransportationacceptanceEntity.class);
			if(transportationacceptanceEntity.getId() == null || transportationacceptanceEntity.getId() == 0){
				BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),transportationacceptanceVO);
				CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
				if(billCode.isSuccess()) {
					// entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
					transportationacceptanceEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
				}else{
					throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
				}
			}
			transportationacceptanceService.saveOrUpdate(transportationacceptanceEntity,false);
			logger.info("---------新增验收单成功--------");
		}
		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
