package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.PurchasecontractdetailEntity;
import com.ejianc.business.purchasingmanagement.bean.TransportationacceptanceEntity;
import com.ejianc.business.purchasingmanagement.service.IPurchasecontractdetailService;
import com.ejianc.business.purchasingmanagement.service.ITransportationacceptanceService;
import com.ejianc.business.purchasingmanagement.vo.AcceptanceVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchasingmanagement.mapper.MaterialacceptanceMapper;
import com.ejianc.business.purchasingmanagement.bean.MaterialacceptanceEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialacceptanceService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 采购材料验收
 * 
 * @author generator
 * 
 */
@Service("materialacceptanceService")
public class MaterialacceptanceServiceImpl extends BaseServiceImpl<MaterialacceptanceMapper, MaterialacceptanceEntity> implements IMaterialacceptanceService{
    @Autowired
    IMaterialacceptanceService service;
    @Autowired
    IPurchasecontractdetailService purchasecontractdetailService;
    @Autowired
    ITransportationacceptanceService transportationacceptanceService;

    /**
     * 查询原材料的本期购入数据
     * @param materialId 原材料id
     * @param acceptanceDate 验收日期
     * @return 原材料的本期购入数量
     */
    @Override
    public AcceptanceVO queryMaterialAcceptance(String materialId, String acceptanceDate,String orgId) {
        AcceptanceVO materialAcceptanceVO = new AcceptanceVO();
        //查询材料验收数据，可能会查询到多条数据
        QueryWrapper query = new QueryWrapper();
        query.eq("material_id",materialId);
        query.eq("acceptance_date",acceptanceDate);
        query.eq("org_id",orgId);
        List<MaterialacceptanceEntity> entities = service.list(query);
        //验收金额总和
        BigDecimal money = BigDecimal.ZERO;
        //数量总和
        BigDecimal account = BigDecimal.ZERO;
        if (!entities.isEmpty()) {
            for (MaterialacceptanceEntity entity : entities) {
                money = money.add(entity.getAmount());
                account = account.add(entity.getAcceptanceQuantity());
                materialAcceptanceVO.setMaterialId(entity.getMaterialId());
                materialAcceptanceVO.setMaterialName(entity.getMaterialName());
                materialAcceptanceVO.setOrgId(entity.getOrgId());
                materialAcceptanceVO.setOrgName(entity.getOrgName());
            }
        }
        materialAcceptanceVO.setAmount(money);
        materialAcceptanceVO.setAcceptanceQuantity(account);
        //判断数量是否为0 是 单价直接写入0 否 单价 = 金额/数量
        if (account.compareTo(BigDecimal.ZERO) == 0)
            materialAcceptanceVO.setPrice(BigDecimal.ZERO);
        if (account.compareTo(BigDecimal.ZERO) != 0)
            materialAcceptanceVO.setPrice(money.divide(account,2,BigDecimal.ROUND_HALF_UP));
        return materialAcceptanceVO;
    }
}
