package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.purchasingmanagement.bean.PurchaseContractEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasecontractdetailEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasetransportationEntity;
import com.ejianc.business.purchasingmanagement.service.IPurchaseContractService;
import com.ejianc.business.purchasingmanagement.service.IPurchasecontractdetailService;
import com.ejianc.business.purchasingmanagement.service.IPurchasetransportationService;
import com.ejianc.business.purchasingmanagement.vo.MaterialplanVO;
import com.ejianc.business.purchasingmanagement.vo.PurchasetransportationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchasingmanagement.mapper.MaterialplanMapper;
import com.ejianc.business.purchasingmanagement.bean.MaterialplanEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialplanService;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 定料计划
 * 
 * @author generator
 * 
 */
@Service("materialplanService")
public class MaterialplanServiceImpl extends BaseServiceImpl<MaterialplanMapper, MaterialplanEntity> implements IMaterialplanService{

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IMaterialplanService service;
    @Autowired
    private IPurchasetransportationService purchasetransportationService;

    @Autowired
    private IPurchasecontractdetailService purchasecontractdetailService;


    @Override
    public CommonResponse<MaterialplanVO> saveChange(MaterialplanVO saveChangeVO) {
        //定料计划生成单据
        //订料计划结束时间设置为23:59:59
        SimpleDateFormat ed = new SimpleDateFormat("yyyy-MM-dd");
        String endTime = ed.format(saveChangeVO.getEndDate())+" 23:59:59";
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date parse = null;
        try {
            parse = sf.parse(endTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        saveChangeVO.setEndDate(parse);
        MaterialplanEntity entity = BeanMapper.map(saveChangeVO, MaterialplanEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveChangeVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setIsColse(1);
                entity.setIsConsignment(1);
                //  entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        PurchasecontractdetailEntity purchasecontractdetailEntity = purchasecontractdetailService.selectById(entity.getPurchasecontractdetailId());
        entity.setPrice(purchasecontractdetailEntity.getPrice());//单价
        entity.setMaterialTax(purchasecontractdetailEntity.getMaterialTax());//材料税率
        entity.setFreightRate(purchasecontractdetailEntity.getFreightRate());// 运费税率


        service.saveOrUpdate(entity, false);
        MaterialplanVO vo = BeanMapper.map(entity, MaterialplanVO.class);

        QueryWrapper<PurchasetransportationEntity> queryWrapper=new QueryWrapper();
        queryWrapper.eq("materialplan_id",vo.getId());
        queryWrapper.eq("dr","0");
        PurchasetransportationEntity page = purchasetransportationService.getOne(queryWrapper);
        if(page == null ){
            //根据定料计划生成采购运输信息单
            PurchasetransportationVO purchasetransportationVO  = new PurchasetransportationVO();
            purchasetransportationVO.setMaterialplanId(vo.getId());//定料计划
            purchasetransportationVO.setSupplierinfoId(vo.getSupplierinfoId());//供应商id
            purchasetransportationVO.setSupplierinfoName(vo.getSupplierinfoName());//供应商名称
            purchasetransportationVO.setMaterialId(vo.getMaterialId());//原材料ID
            purchasetransportationVO.setMaterialName(vo.getMaterialName());//原材料
            purchasetransportationVO.setRequiredQuantity(vo.getQuantity());//需求数量
            purchasetransportationVO.setReceivingaddressId(vo.getMddId());//收货地址ID
            purchasetransportationVO.setReceivingAddress(vo.getMddName());//收货地址
            purchasetransportationVO.setOrgId(vo.getOrgId());//组织ID
            purchasetransportationVO.setOrgName(vo.getOrgName());//组织名称
            purchasetransportationVO.setShippersId(purchasecontractdetailEntity.getShippersId());//运输商id
            purchasetransportationVO.setShippersName(purchasecontractdetailEntity.getShippersName());//运输商
            purchasetransportationVO.setUnitPrice(purchasecontractdetailEntity.getSjyfPrice());//运费
            purchasetransportationVO.setDistance(purchasecontractdetailEntity.getDistance());//运距
            purchasetransportationVO.setStartingTime(vo.getStarDate());
            purchasetransportationVO.setEndTime(vo.getEndDate());
            purchasetransportationVO.setIsColse(1);
            purchasetransportationVO.setIsConsignment(1);
            purchasetransportationVO.setIsAccept(0);

            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),purchasetransportationVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {

                PurchasetransportationEntity entity1 = BeanMapper.map(purchasetransportationVO, PurchasetransportationEntity.class);
                entity1.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                purchasetransportationService.saveOrUpdate(entity1, false);
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

        }else{
            page.setRequiredQuantity(vo.getQuantity());//需求数量
            page.setReceivingaddressId(vo.getMddId());//收货地址ID
            page.setReceivingAddress(vo.getMddName());//收货地址
            page.setStartingTime(vo.getStarDate());
            page.setEndTime(vo.getEndDate());
            page.setMaterialId(vo.getMaterialId());//原材料ID
            page.setMaterialName(vo.getMaterialName());//原材料
            page.setSupplierinfoId(vo.getSupplierinfoId());//供应商id
            page.setSupplierinfoName(vo.getSupplierinfoName());//供应商名称
            purchasetransportationService.updateById(page);
        }

        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> orderingSchedulesTime() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        QueryWrapper<MaterialplanEntity> queryWrapper=new QueryWrapper();
        //queryWrapper.select("select * from  ejc_purchasingmanagement_purchasecontract where end_date<"+sdf.format(date));
        queryWrapper.le("end_date",date);
        queryWrapper.eq("is_colse",1);
        List<MaterialplanEntity> materialplanEntities  = service.list(queryWrapper);
        for (MaterialplanEntity temp : materialplanEntities ) {
            temp.setIsColse(0);
            temp.setBillState(3);
            service.updateById(temp);
            QueryWrapper<PurchasetransportationEntity> purchasetransportationEntityQueryWrapper = new QueryWrapper<>();
            purchasetransportationEntityQueryWrapper.eq("materialplan_id",temp.getId());
            PurchasetransportationEntity purchasetransportationEntitie = purchasetransportationService.getOne(purchasetransportationEntityQueryWrapper);
            purchasetransportationEntitie.setIsColse(0);
            purchasetransportationEntitie.setBillState(3);
            purchasetransportationService.updateById(purchasetransportationEntitie);

        }
        return CommonResponse.success("订料计划定时任务执行完成！") ;
    }
}
