package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.MaterialplanEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasetransportationEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialplanService;
import com.ejianc.business.purchasingmanagement.service.IPurchasetransportationService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchasingmanagement.mapper.PurchaseContractMapper;
import com.ejianc.business.purchasingmanagement.bean.PurchaseContractEntity;
import com.ejianc.business.purchasingmanagement.service.IPurchaseContractService;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 采购合同
 * 
 * @author generator
 * 
 */
@Service("purchaseContractService")
public class PurchaseContractServiceImpl extends BaseServiceImpl<PurchaseContractMapper, PurchaseContractEntity> implements IPurchaseContractService{


    @Autowired
    private IPurchaseContractService service;
    @Autowired
    private IMaterialplanService materialplanService;
    @Autowired
    private IPurchasetransportationService purchasetransportationService;
    @Override
    public CommonResponse<String> contractTime() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        QueryWrapper<PurchaseContractEntity> queryWrapper=new QueryWrapper();
        //queryWrapper.select("select * from  ejc_purchasingmanagement_purchasecontract where end_date<"+sdf.format(date));
        queryWrapper.le("end_date",date);
        queryWrapper.le("stage",0);
        List<PurchaseContractEntity>   purchaseContractEntities  = service.list(queryWrapper);
        for (PurchaseContractEntity temp : purchaseContractEntities ) {
            temp.setStage(1);
            service.updateById(temp);
            QueryWrapper<MaterialplanEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("purchasecontract_id",temp.getId());
            List<MaterialplanEntity> list = materialplanService.list(queryWrapper1);
            for (MaterialplanEntity entity : list){
                entity.setIsColse(0);
                entity.setBillState(3);
                materialplanService.updateById(entity);
                QueryWrapper<PurchasetransportationEntity> queryWrapper2 = new QueryWrapper<>();
                queryWrapper2.eq("materialplan_id",entity.getId());
                PurchasetransportationEntity purchasetransportationEntity = purchasetransportationService.getOne(queryWrapper2);
                purchasetransportationEntity.setIsColse(0);
                purchasetransportationEntity.setBillState(3);
                purchasetransportationService.updateById(purchasetransportationEntity);
            }
        }
        return CommonResponse.success("采购合同定时任务执行完成！") ;
    }
}
