package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.MaterialplanEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasecontractdetailEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasetransportationEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialplanService;
import com.ejianc.business.purchasingmanagement.service.IPurchasecontractdetailService;
import com.ejianc.business.purchasingmanagement.service.IPurchasetransportationService;
import com.ejianc.business.purchasingmanagement.vo.PurchasedetilVO;
import com.ejianc.business.purchasingmanagement.vo.ShippingVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchasingmanagement.mapper.PurchasedetilMapper;
import com.ejianc.business.purchasingmanagement.bean.PurchasedetilEntity;
import com.ejianc.business.purchasingmanagement.service.IPurchasedetilService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 采购运输信息明细
 * 
 * @author generator
 * 
 */
@Service("purchasedetilService")
public class PurchasedetilServiceImpl extends BaseServiceImpl<PurchasedetilMapper, PurchasedetilEntity> implements IPurchasedetilService{
    @Autowired
    private IPurchasedetilService service;
    @Autowired
    private IPurchasetransportationService purchasetransportationService;

    @Autowired
    private IPurchasecontractdetailService purchasecontractdetailService;
    @Autowired
    private IMaterialplanService materialplanService;
    @Autowired
    private PurchasedetilMapper purchasedetilMapper;
    @Override
    public boolean saveOrChange(PurchasedetilVO PurchasedetilVO) {
        PurchasedetilEntity entity = BeanMapper.map(PurchasedetilVO, PurchasedetilEntity.class);
        PurchasetransportationEntity purchasetransportationEntity  =  purchasetransportationService.selectById(entity.getPurchasetransportationId());
        MaterialplanEntity materialplanEntity =  materialplanService.getById(purchasetransportationEntity.getMaterialplanId());
        PurchasecontractdetailEntity purchasecontractdetailEntity =    purchasecontractdetailService.selectById(materialplanEntity.getPurchasecontractdetailId());
        entity.setMaterialplanId(purchasetransportationEntity.getMaterialplanId());//定料计划ID
        entity.setSupplierinfoId(purchasetransportationEntity.getSupplierinfoId());//供应商ID
        entity.setSupplierinfoName(purchasetransportationEntity.getSupplierinfoName());//供应商
        entity.setMaterialId(purchasetransportationEntity.getMaterialId());// 原材料ID
        entity.setMaterialName(purchasetransportationEntity.getMaterialName());//原材料名称
        entity.setStatus(0);//未收货
        entity.setOrgId(purchasetransportationEntity.getOrgId());//组织ID
        entity.setOrgName(purchasetransportationEntity.getOrgName());//组织名称
        entity.setShippersId(purchasetransportationEntity.getShippersId());//运输商ID
        entity.setShippersName(purchasetransportationEntity.getShippersName());//运输商名称
        entity.setDeductionRate(purchasecontractdetailEntity.getDeductionRate());//扣率
        entity.setDecimalPoint(purchasecontractdetailEntity.getDecimalPoint());//小数点
        service.saveOrUpdate(entity, false);
        //purchasetransportationService.selectById(entity.getPurchasetransportationId());
        QueryWrapper<PurchasedetilEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("purchasetransportation_id",entity.getPurchasetransportationId());
        List<PurchasedetilEntity> purchasedetilEntities  = service.list(queryWrapper);
        BigDecimal sum = new BigDecimal(0.00);
        for (PurchasedetilEntity temp : purchasedetilEntities) {
            sum = sum.add(temp.getDeliveryQuantity());
        }
        purchasetransportationEntity.setDeliveryQuantity(sum);
        purchasetransportationEntity.setIsConsignment(0);
        purchasetransportationService.updateById(purchasetransportationEntity);
        materialplanEntity.setIssuedQuantity(sum);
        materialplanEntity.setIsConsignment(0);
        materialplanService.updateById(materialplanEntity);
        return true;
    }

    @Override
    public List<ShippingVO> selectList(String startingTime, String endTime, String materialName, String orgId, String code) {
        List<ShippingVO> list = purchasedetilMapper.selectList(startingTime,endTime,materialName,orgId,code);
        return list;
    }
}
