package com.ejianc.business.purchasingmanagement.service.impl;

import com.ejianc.business.purchasingmanagement.bean.*;
import com.ejianc.business.purchasingmanagement.service.IMaterialacceptanceService;
import com.ejianc.business.purchasingmanagement.service.IPurchaseContractService;
import com.ejianc.business.purchasingmanagement.service.IPurchasecontractdetailService;
import com.ejianc.business.purchasingmanagement.service.ISalesreconciliationService;
import com.ejianc.business.purchasingmanagement.vo.MaterialacceptanceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;

@Service("salesreconciliation") 
public class SalesreconciliationBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IOrgApi iOrgApi;
	@Autowired
	private ISalesreconciliationService service;
	@Autowired
	private IMaterialacceptanceService materialacceptanceService;
	@Autowired
	private IPurchaseContractService purchaseContractService;
	@Autowired
	private IPurchasecontractdetailService purchasecontractdetailService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("---------进来啦--------");
		SalesreconciliationEntity entity = service.selectById(billId);
		if(entity.getSalesreconciliationdetailList().size() > 0){
			logger.info("---------不为空--------");
			for(SalesreconciliationdetailEntity detailEntity : entity.getSalesreconciliationdetailList()){
				MaterialacceptanceEntity materialacceptanceEntity = materialacceptanceService.getById(detailEntity.getMaterialacceptanceId());
				materialacceptanceEntity.setMeetMoney(detailEntity.getAdjustedMoney());
				logger.info("---------已修改--------");
				materialacceptanceService.updateById(materialacceptanceEntity);
			}
		}else{
			PurchasecontractdetailEntity purchasecontractdetailEntity = purchasecontractdetailService.getById(entity.getMaterialId());
			PurchaseContractEntity purchaseContractEntity = purchaseContractService.getById(entity.getContractId());


			MaterialacceptanceVO materialacceptanceVO= new MaterialacceptanceVO();
			materialacceptanceVO.setSupplierinfoId(entity.getSupplierId());
			materialacceptanceVO.setSupplierinfoName(entity.getSupplierName());
			materialacceptanceVO.setAcceptanceQuantity(new BigDecimal(0.00));
			materialacceptanceVO.setTaxrate(purchasecontractdetailEntity.getMaterialTax());
			materialacceptanceVO.setPurchasecontractId(entity.getContractId());
			materialacceptanceVO.setPurchasecontractBillCode(purchaseContractEntity.getBillCode());
			materialacceptanceVO.setPurchasecontractMaterialId(entity.getMaterialId());
			materialacceptanceVO.setPurchasecontractMaterialName(entity.getMaterialName());
			materialacceptanceVO.setTotalAmount(entity.getAdjustmentAmount());//含税金额
			BigDecimal tax = new BigDecimal(1.00).add(purchasecontractdetailEntity.getMaterialTax());
			materialacceptanceVO.setTax(entity.getAdjustmentAmount().divide(tax,2,BigDecimal.ROUND_HALF_UP));//税额
			materialacceptanceVO.setAmount(entity.getAdjustmentAmount().subtract(materialacceptanceVO.getTax()));//不含税金额
			materialacceptanceVO.setAcceptanceDate(entity.getDate());
			materialacceptanceVO.setOrgId(purchaseContractEntity.getOrgId());
			materialacceptanceVO.setOrgName(purchaseContractEntity.getOrgName());

			materialacceptanceVO.setAmountPaid(new BigDecimal(0.00));
			materialacceptanceVO.setMeetMoney(materialacceptanceVO.getTotalAmount());
			materialacceptanceVO.setAmountNotPaid(materialacceptanceVO.getMeetMoney().subtract(materialacceptanceVO.getAmountPaid()));
			materialacceptanceVO.setInvoiceReceived(new BigDecimal(0.00));
			materialacceptanceVO.setInvoiceNotReceived(materialacceptanceVO.getTotalAmount());
			materialacceptanceVO.setIsSign(1);
			materialacceptanceVO.setAcceptanceType(1);
			materialacceptanceVO.setSalesreconciliationId(entity.getId());
			MaterialacceptanceEntity entitys = BeanMapper.map(materialacceptanceVO, MaterialacceptanceEntity.class);
			if(entitys.getId() == null || entitys.getId() == 0){
				BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),materialacceptanceVO);
				CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
				if(billCode.isSuccess()) {
					// entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
					entitys.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
				}else{
					throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
				}
			}
			materialacceptanceService.saveOrUpdate(entitys,false);
			logger.info("---------新增验收单成功--------");
		}
		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
