package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.vo.AcceptanceVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchasingmanagement.mapper.TransportationacceptanceMapper;
import com.ejianc.business.purchasingmanagement.bean.TransportationacceptanceEntity;
import com.ejianc.business.purchasingmanagement.service.ITransportationacceptanceService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 采购运输验收
 * 
 * @author generator
 * 
 */
@Service("transportationacceptanceService")
public class TransportationacceptanceServiceImpl extends BaseServiceImpl<TransportationacceptanceMapper, TransportationacceptanceEntity> implements ITransportationacceptanceService{
    @Autowired
    private ITransportationacceptanceService service;
    @Override
    public BigDecimal queryTransportationacceptanceMoney(String materialId, String acceptanceDate,String orgId) {
        //查询材料验收数据，可能会查询到多条数据
        QueryWrapper query = new QueryWrapper();
        query.eq("material_id",materialId);
        query.eq("acceptance_date",acceptanceDate);
        query.eq("org_id",orgId);
        List<TransportationacceptanceEntity> list = service.list(query);
        //验收金额总和
        BigDecimal money = BigDecimal.ZERO;
        if (!list.isEmpty()){
            for (TransportationacceptanceEntity entity : list) {
                money = money.add(entity.getMoney());
            }
        }
        return money;
    }
}
