package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 采购运输信息
 * 
 * @author generator
 * 
 */
public class PurchasetransportationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long materialplanId; // 定料计划主键
    private String materialplanName; // 定料计划名称
    private Long supplierinfoId; // 供应商基本档案主键
    private String supplierinfoName; // 供应商基本档案名称
    private Long materialId; // 原材类主键
    private String materialName; // 原材类名称
    private Long shippersId; // 运输商主键
    private String shippersName; // 运输商名称
    private Long shippersVehicleId; // 运输车辆主键
    private String shippersVehicleName; // 运输车辆名称
    private BigDecimal deliveryQuantity; // 发货数量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date deliveryTime; // 发货时间
    private BigDecimal receiptQuantity; // 收货数量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date receiptTime; // 收货时间
    private Integer shippingMethod; // 运输方式
    private BigDecimal distance; // 运距
    private BigDecimal unitPrice; // 运输单价
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号
    private Long receivingaddressId;    //收货地址ID
    private String receivingAddress;    //收货地址
    private BigDecimal requiredQuantity;    //需求数量
    private BigDecimal tareWeight;    //皮重
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startingTime ;//开始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime ;//结束时间
    private Integer isColse ;//是否关闭  0-是 1-否
    private Integer isConsignment;//是否发货 0-已发货 1-未发货
    private Integer isAccept;//是否接受 0-未接受 1-已接受

    private String purchasetransportationBillCode;//采购运输信息


    private List<PurchasedetilVO> purchasedetilList = new ArrayList<>(); // 采购运输信息明细

    public String getPurchasetransportationBillCode() {
        return purchasetransportationBillCode;
    }

    public void setPurchasetransportationBillCode(String purchasetransportationBillCode) {
        this.purchasetransportationBillCode = purchasetransportationBillCode;
    }

    public Date getStartingTime() {
        return startingTime;
    }

    public void setStartingTime(Date startingTime) {
        this.startingTime = startingTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public BigDecimal getTareWeight() {
        return tareWeight;
    }

    public void setTareWeight(BigDecimal tareWeight) {
        this.tareWeight = tareWeight;
    }

    public BigDecimal getDeliveryQuantity() {
        return deliveryQuantity;
    }

    public void setDeliveryQuantity(BigDecimal deliveryQuantity) {
        this.deliveryQuantity = deliveryQuantity;
    }

    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public BigDecimal getReceiptQuantity() {
        return receiptQuantity;
    }

    public void setReceiptQuantity(BigDecimal receiptQuantity) {
        this.receiptQuantity = receiptQuantity;
    }

    public Date getReceiptTime() {
        return receiptTime;
    }

    public void setReceiptTime(Date receiptTime) {
        this.receiptTime = receiptTime;
    }

    public Integer getShippingMethod() {
        return shippingMethod;
    }

    public void setShippingMethod(Integer shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    public BigDecimal getDistance() {
        return distance;
    }

    public void setDistance(BigDecimal distance) {
        this.distance = distance;
    }

    public BigDecimal getRequiredQuantity() {
        return requiredQuantity;
    }

    public void setRequiredQuantity(BigDecimal requiredQuantity) {
        this.requiredQuantity = requiredQuantity;
    }

    public void setReceivingaddressId(Long receivingaddressId) {
        this.receivingaddressId = receivingaddressId;
    }

    public void setReceivingAddress(String receivingAddress) {
        this.receivingAddress = receivingAddress;
    }



    public Long getReceivingaddressId() {
        return receivingaddressId;
    }

    public String getReceivingAddress() {
        return receivingAddress;
    }



    public List<PurchasedetilVO> getPurchasedetilList() {
        return purchasedetilList;
    }

    public void setPurchasedetilList(List<PurchasedetilVO> purchasedetilList) {
        this.purchasedetilList = purchasedetilList;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialplanId() {
        return materialplanId;
    }

    public void setMaterialplanId(Long materialplanId) {
        this.materialplanId = materialplanId;
    }
    public String getMaterialplanName() {
        return materialplanName;
    }

    public void setMaterialplanName(String materialplanName) {
        this.materialplanName = materialplanName;
    }
    @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }
    @ReferDeserialTransfer
    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }

    @ReferSerialTransfer(referCode="ShippersRef")
    public Long getShippersId() {
        return shippersId;
    }
    @ReferDeserialTransfer
    public void setShippersId(Long shippersId) {
        this.shippersId = shippersId;
    }
    public String getShippersName() {
        return shippersName;
    }

    public void setShippersName(String shippersName) {
        this.shippersName = shippersName;
    }
    public Long getShippersVehicleId() {
        return shippersVehicleId;
    }

    public void setShippersVehicleId(Long shippersVehicleId) {
        this.shippersVehicleId = shippersVehicleId;
    }
    public String getShippersVehicleName() {
        return shippersVehicleName;
    }

    public void setShippersVehicleName(String shippersVehicleName) {
        this.shippersVehicleName = shippersVehicleName;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getIsColse() {
        return isColse;
    }

    public void setIsColse(Integer isColse) {
        this.isColse = isColse;
    }

    public Integer getIsConsignment() {
        return isConsignment;
    }

    public void setIsConsignment(Integer isConsignment) {
        this.isConsignment = isConsignment;
    }

    public Integer getIsAccept() {
        return isAccept;
    }

    public void setIsAccept(Integer isAccept) {
        this.isAccept = isAccept;
    }
}
