package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.purchasingmanagement.bean.SalesreconciliationdetailEntity;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 采购调账单
 * 
 * @author generator
 * 
 */
public class SalesreconciliationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long supplierId; // 供应商主键
    private String supplierName; // 供应商名称
    private Long contractId; // 合同主键
    private String contractName; // 合同名称
    private Long materialId; // 原材料主键（合同子表原材料）
    private String materialName; // 原材料名称
    private BigDecimal totalAmount; // 合同总金额（即该供应商该合同下所有验收单的总金额）
    private BigDecimal uncollectedAmount; // 剩余未收金额
    private BigDecimal adjustmentAmount; // 调账金额
    private BigDecimal adjustmentBalance; // 调账余额
    private BigDecimal amountAfterAdjustment; // 调账后金额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date; // 业务发生所属日期
    private Date entryDate; // 录时间入
    private String reason; // 调账原因
    private Integer status; // 调账状态:1确认0未确认2调账中
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号
    private Long signId; // 签认单id
    private BigDecimal distributionMoeny; // 分配金额
    private BigDecimal remainingUnpaidMoney; // 剩余未付金额
    private List<SalesreconciliationdetailVO> salesreconciliationdetailList = new ArrayList<>(); // 调账单子表
    //导出使用
    private String dates;//业务发生所属日期
    private String entryDates;//录入时间



    @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    @ReferSerialTransfer(referCode="PurchaseContractRef")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode="PurchasecontractdetailRef")
    public Long getMaterialId() {
        return materialId;
    }

    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }
    public BigDecimal getUncollectedAmount() {
        return uncollectedAmount;
    }

    public void setUncollectedAmount(BigDecimal uncollectedAmount) {
        this.uncollectedAmount = uncollectedAmount;
    }
    public BigDecimal getAdjustmentAmount() {
        return adjustmentAmount;
    }

    public void setAdjustmentAmount(BigDecimal adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
    }
    public BigDecimal getAdjustmentBalance() {
        return adjustmentBalance;
    }

    public void setAdjustmentBalance(BigDecimal adjustmentBalance) {
        this.adjustmentBalance = adjustmentBalance;
    }
    public BigDecimal getAmountAfterAdjustment() {
        return amountAfterAdjustment;
    }

    public void setAmountAfterAdjustment(BigDecimal amountAfterAdjustment) {
        this.amountAfterAdjustment = amountAfterAdjustment;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public Date getEntryDate() {
        return entryDate;
    }

    public void setEntryDate(Date entryDate) {
        this.entryDate = entryDate;
    }
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getSignId() {
        return signId;
    }

    public void setSignId(Long signId) {
        this.signId = signId;
    }
    public BigDecimal getDistributionMoeny() {
        return distributionMoeny;
    }

    public void setDistributionMoeny(BigDecimal distributionMoeny) {
        this.distributionMoeny = distributionMoeny;
    }

    public List<SalesreconciliationdetailVO> getSalesreconciliationdetailList() {
        return salesreconciliationdetailList;
    }

    public void setSalesreconciliationdetailList(List<SalesreconciliationdetailVO> salesreconciliationdetailList) {
        this.salesreconciliationdetailList = salesreconciliationdetailList;
    }

    public BigDecimal getRemainingUnpaidMoney() {
        return remainingUnpaidMoney;
    }

    public void setRemainingUnpaidMoney(BigDecimal remainingUnpaidMoney) {
        this.remainingUnpaidMoney = remainingUnpaidMoney;
    }
    public String getDates() {
        return dates;
    }

    public void setDates(String dates) {
        this.dates = dates;
    }

    public String getEntryDates() {
        return entryDates;
    }

    public void setEntryDates(String entryDates) {
        this.entryDates = entryDates;
    }
}
