package com.ejianc.business.scene.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 应急演练计划清单
 * 
 * @author generator
 * 
 */
public class EmergencyPlanDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long drillCategory; // 演练类型
    private String drillCategoryName; // 演练类型
    private String drillContent; // 演习内容
    private String organizationalUnits; // 组织部门
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date drillTime; // 演练时间
    private String drillType; // 演练形式
    private String drillPeople; // 参加人员
    private BigDecimal mny; // 费用预算（万元）
    private String memo; // 备注
    private Long pid; // 主表id
    private String projectName; // 项目名称
    private String unitName;

    public String getDrillCategoryName() {
        return drillCategoryName;
    }

    public void setDrillCategoryName(String drillCategoryName) {
        this.drillCategoryName = drillCategoryName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getDrillCategory() {
        return drillCategory;
    }
    @ReferDeserialTransfer
    public void setDrillCategory(Long drillCategory) {
        this.drillCategory = drillCategory;
    }
    public String getDrillContent() {
        return drillContent;
    }

    public void setDrillContent(String drillContent) {
        this.drillContent = drillContent;
    }
    public String getOrganizationalUnits() {
        return organizationalUnits;
    }

    public void setOrganizationalUnits(String organizationalUnits) {
        this.organizationalUnits = organizationalUnits;
    }
    public Date getDrillTime() {
        return drillTime;
    }

    public void setDrillTime(Date drillTime) {
        this.drillTime = drillTime;
    }
    public String getDrillType() {
        return drillType;
    }

    public void setDrillType(String drillType) {
        this.drillType = drillType;
    }
    public String getDrillPeople() {
        return drillPeople;
    }

    public void setDrillPeople(String drillPeopleNum) {
        this.drillPeople = drillPeopleNum;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    
}
