/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.safety.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.safety.bean.SafetySceneCheckDetailEntity;
import com.ejianc.business.safety.bean.SafetySceneCheckEntity;
import com.ejianc.business.safety.service.ISafetySceneCheckDetailService;
import com.ejianc.business.safety.service.ISafetySceneCheckService;
import com.ejianc.business.safety.service.ISafetySceneQualityCheckItemService;
import com.ejianc.business.safety.service.ISafetySceneSafetyCheckItemService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.GetAutoCode;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.vo.CheckDetailReportVO;
import com.ejianc.business.scene.vo.DangerReportVo;
import com.ejianc.business.scene.vo.NewProblemVo;
import com.ejianc.business.scene.vo.SafetySceneCheckDetailVO;
import com.ejianc.business.scene.vo.SafetySceneCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"safetySceneCheck"})
@Api(value="\u68c0\u67e5\u5355\u4e3b\u8868", tags={"\u68c0\u67e5\u5355\u4e3b\u8868"})
public class SafetySceneCheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SAFETY-SCENE-CHECK-DETAIL-CODE";
    @Autowired
    private ISafetySceneCheckService service;
    @Autowired
    private ISafetySceneCheckDetailService detailService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${oms.fileServerPath}")
    private String baseImgUrl;
    @Autowired
    ICommonBusinessService sceneCheck;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private ISafetySceneSafetyCheckItemService safetyCheckItemService;
    @Autowired
    private ISafetySceneQualityCheckItemService qualityCheckItemService;

    @ApiOperation(value="\u5b89\u5168\u5206\u6790\u95e8\u6237")
    @RequestMapping(value={"/querySafetyAnalysisPortal"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> safetyAnalysisPortal(@RequestParam(value="id") Long projectId) {
        JSONObject js = this.service.queryQualityOrSafeCount(projectId, "1");
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)js);
    }

    @ApiOperation(value="\u6d4b\u8bd5\u6d88\u606f")
    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SafetySceneCheckVO> test(@RequestParam Long id) {
        this.sceneCheck.afterApprovalProcessor(id, null, null);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryNewProblemReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<NewProblemVo>> queryNewProblemReport(@RequestParam String date, @RequestParam Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u65b0\u589e\u95ee\u9898\u5360\u6bd4\u8868", this.service.queryNewProblemReport(date, projectId));
    }

    @RequestMapping(value={"/queryDangerReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DangerReportVo>> queryDangerReport(@RequestParam String date) {
        return CommonResponse.success((String)"\u67e5\u8be2\u98ce\u9669\u8bc6\u522b\u6c47\u603b\u8868\u6210\u529f", this.service.queryDangerReport(date));
    }

    @RequestMapping(value={"/queryProblemTopN"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryProblemTopN(@RequestParam(value="topN", defaultValue="5") Integer topN, @RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u95ee\u9898TOP5\u6210\u529f", (Object)this.service.queryProblemTopN(topN, projectId));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SafetySceneCheckVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SafetySceneCheckVO saveorUpdateVO) {
        SafetySceneCheckEntity entity = (SafetySceneCheckEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SafetySceneCheckEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setReformStatus(Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
        }
        List<SafetySceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        int count = 0;
        for (SafetySceneCheckDetailEntity sceneCheckDetail : sceneCheckDetails) {
            if (sceneCheckDetail.getRowState() == null || !"del".equals(sceneCheckDetail.getRowState())) {
                ++count;
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sceneCheckDetail.getBillCode())) {
                    sceneCheckDetail.setBillCode(entity.getBillCode() + "-" + GetAutoCode.getTowPipelineNumbers((int)count));
                }
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sceneCheckDetail.getCheckName())) {
                sceneCheckDetail.setCheckName(entity.getCheckName());
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sceneCheckDetail.getProjectName())) {
                sceneCheckDetail.setProjectName(entity.getProjectName());
            }
            if (sceneCheckDetail.getIsReform() == null) {
                sceneCheckDetail.setIsReform(Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
            }
            if (sceneCheckDetail.getCheckType() == null) {
                sceneCheckDetail.setCheckType(entity.getCheckType());
                sceneCheckDetail.setCheckTypeName(entity.getCheckTypeName());
            }
            if (sceneCheckDetail.getReformNumber() == null) {
                sceneCheckDetail.setReformNumber(0);
            }
            sceneCheckDetail.setCheckAttr(entity.getCheckAttr());
            sceneCheckDetail.setCheckAttrName(entity.getCheckAttrName());
        }
        entity.setReviewItem(count);
        this.service.saveOrUpdate((Object)entity, false);
        List<SafetySceneCheckDetailEntity> sceneCheckDetails1 = entity.getSceneCheckDetails();
        List sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails1, SafetySceneCheckDetailVO.class);
        sceneCheckDetailVOList.forEach(item -> item.setBaseImgUrl(this.baseImgUrl));
        SafetySceneCheckVO vo = (SafetySceneCheckVO)BeanMapper.map((Object)((Object)entity), SafetySceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SafetySceneCheckVO> queryDetail(@RequestParam Long id) {
        SafetySceneCheckEntity entity = (SafetySceneCheckEntity)((Object)this.service.selectById(id));
        List<SafetySceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails, SafetySceneCheckDetailVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetailVOList.forEach(item -> item.setBaseImgUrl(this.baseImgUrl));
        }
        SafetySceneCheckVO vo = (SafetySceneCheckVO)BeanMapper.map((Object)((Object)entity), SafetySceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SafetySceneCheckVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u68c0\u67e5\u5355\u5217\u8868\u67e5\u8be2")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SafetySceneCheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SafetySceneCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List sceneCheckVOS = BeanMapper.mapList((Iterable)list, SafetySceneCheckVO.class);
        if (CollectionUtils.isNotEmpty((Collection)sceneCheckVOS)) {
            sceneCheckVOS.forEach(t -> {
                if (t.getCheckLevel() != null) {
                    t.setCheckLevelName(1 == t.getCheckLevel() ? "\u9879\u76ee" : "\u516c\u53f8");
                }
            });
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().exportWithTrans("SafetySceneCheck-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refSceneCheckData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SafetySceneCheckVO>> refSceneCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SafetySceneCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u73b0\u573a\u68c0\u67e5\u53f0\u8d26")
    @RequestMapping(value={"/queryCheckItemList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckDetailReportVO>> queryCheckItemList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("checkCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkItem");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<CheckDetailReportVO> list = this.service.queryCheckItemList((IPage<CheckDetailReportVO>)page, param, orgIds);
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @ApiOperation(value="\u73b0\u573a\u68c0\u67e5\u53f0\u8d26- \u5bfc\u51fa")
    @RequestMapping(value={"/exportCheckItemList"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportCheckItemList(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("checkCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkItem");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<CheckDetailReportVO> list = this.service.queryCheckItemList((IPage<CheckDetailReportVO>)page, param, orgIds);
        HashMap<String, List<CheckDetailReportVO>> beans = new HashMap<String, List<CheckDetailReportVO>>();
        for (CheckDetailReportVO checkDetailReportVO : list) {
            if (checkDetailReportVO.getQualityCheckType() != null && checkDetailReportVO.getQualityCheckType().equals(0)) {
                checkDetailReportVO.setQualityCheckTypeName("\u5b89\u5168\u7ba1\u7406\u68c0\u67e5");
            }
            if (checkDetailReportVO.getQualityCheckType() == null || !checkDetailReportVO.getQualityCheckType().equals(1)) continue;
            checkDetailReportVO.setQualityCheckTypeName("\u5b89\u5168\u884c\u4e3a\u68c0\u67e5");
        }
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("SafetyCheckItemList-export.xlsx", beans, response);
    }

    @ApiOperation(value="queryCheckItemCount")
    @RequestMapping(value={"/queryCheckItemCount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryCheckItemCount(@RequestBody QueryParam param) {
        param.getParams().put("c.tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("c.orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("c.orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        JSONObject obj = this.service.queryCheckItemCount(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)obj);
    }

    @ApiOperation(value="queryBoardCheckItemCount")
    @RequestMapping(value={"/queryBoardCheckItemCount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryBoardCheckItemCount(@RequestBody QueryParam param) {
        param.getParams().put("c.tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("c.orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("c.orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        JSONObject obj = this.service.queryBoardCheckItemCount(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)obj);
    }

    public static void main(String[] args) {
        System.out.println("2023121309".substring(2, 8));
    }
}

