package com.ejianc.business.quality.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.quality.vo.QualityEventContentVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 质量事件
 * 
 * @author generator
 * 
 */
public class QualityEventVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private String secondUnit; // 二级单位
    private String eventType; // 事件类型
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registerDate; // 登记日期
    private String punishType; // 处罚分类
    private String punishGrade; // 处罚事件分级
    private BigDecimal eventMny; // 事件损失金额
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String employeePart; // 经办部门
    private String reward; // 奖励描述
    private String qualityProblem; // 质量问题描述
    private String measure; // 纠正和预防措施/实践描述
    private String punishEvent; // 处罚情况(经济处罚与行政处罚)其他
    private Integer billState; // 单据状态
    private String billStateName;
    private String billCode; // 单据编码
    private Long parentOrgId; // 父工程ID
    private String parentOrgName; // 夫工程名称
    private String parentOrgCode; // 夫工程编码
    private Long orgId; // 工程ID
    private String orgName; // 工程名称
    private String orgCode; // 工程编码

    private Long sourceId;

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    private List<QualityEventContentVO> detailList = new ArrayList<>(); // 质量事件子表


    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    /**
     * 编制人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getSecondUnit() {
        return secondUnit;
    }

    public void setSecondUnit(String secondUnit) {
        this.secondUnit = secondUnit;
    }
    public String getEventType() {
        return eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }
    public Date getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }
    public String getPunishType() {
        return punishType;
    }

    public void setPunishType(String punishType) {
        this.punishType = punishType;
    }
    public String getPunishGrade() {
        return punishGrade;
    }

    public void setPunishGrade(String punishGrade) {
        this.punishGrade = punishGrade;
    }
    public BigDecimal getEventMny() {
        return eventMny;
    }

    public void setEventMny(BigDecimal eventMny) {
        this.eventMny = eventMny;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeePart() {
        return employeePart;
    }

    public void setEmployeePart(String employeePart) {
        this.employeePart = employeePart;
    }
    public String getReward() {
        return reward;
    }

    public void setReward(String reward) {
        this.reward = reward;
    }
    public String getQualityProblem() {
        return qualityProblem;
    }

    public void setQualityProblem(String qualityProblem) {
        this.qualityProblem = qualityProblem;
    }
    public String getMeasure() {
        return measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }
    public String getPunishEvent() {
        return punishEvent;
    }

    public void setPunishEvent(String punishEvent) {
        this.punishEvent = punishEvent;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<QualityEventContentVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<QualityEventContentVO> detailList) {
        this.detailList = detailList;
     }
}
