/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.safety.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.safety.bean.FeedbackPlanEntity;
import com.ejianc.business.safety.service.IFeedbackPlanDetailService;
import com.ejianc.business.safety.service.IFeedbackPlanService;
import com.ejianc.business.scene.vo.FeedbackPlanDetailVO;
import com.ejianc.business.scene.vo.FeedbackPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"feedbackPlan"})
public class FeedbackPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FEEDBACK-PLAN";
    @Autowired
    private IFeedbackPlanService service;
    @Autowired
    private IFeedbackPlanDetailService feedbackPlanDetailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IFeedbackPlanDetailService detailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FeedbackPlanVO> saveOrUpdate(@RequestBody FeedbackPlanVO saveOrUpdateVO) {
        FeedbackPlanEntity entity = (FeedbackPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FeedbackPlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        FeedbackPlanVO vo = (FeedbackPlanVO)BeanMapper.map((Object)((Object)entity), FeedbackPlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FeedbackPlanVO> queryDetail(Long id) {
        FeedbackPlanEntity entity = (FeedbackPlanEntity)((Object)this.service.selectById(id));
        FeedbackPlanVO vo = (FeedbackPlanVO)BeanMapper.map((Object)((Object)entity), FeedbackPlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FeedbackPlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FeedbackPlanVO feedbackPlanVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FeedbackPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FeedbackPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryTZList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FeedbackPlanDetailVO>> queryTZList(@RequestBody QueryParam param) {
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("unitName");
        param.getFuzzyFields().add("feedbackContent");
        param.getFuzzyFields().add("feedbackObject");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        List trainPlanEntityList = this.service.queryList(queryParam);
        if (!CollectionUtils.isEmpty((Collection)trainPlanEntityList) && trainPlanEntityList.size() > 0) {
            List ids = trainPlanEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            Map<Long, String> projectName = trainPlanEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, FeedbackPlanEntity::getProjectName));
            Map<Long, String> unitName = trainPlanEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, FeedbackPlanEntity::getUnitName));
            param.getParams().put("pid", new Parameter("in", ids));
            IPage page = this.detailService.queryPage(param, false);
            List voList = BeanMapper.mapList((Iterable)page.getRecords(), FeedbackPlanDetailVO.class);
            voList.forEach(e -> {
                e.setProjectName((String)projectName.get(e.getPid()));
                e.setUnitName((String)unitName.get(e.getPid()));
            });
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(voList);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", null);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, FeedbackPlanVO.class);
        voList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        beans.put("records", voList);
        ExcelExport.getInstance().export("FeedbackPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelTZExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelTZExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List trainPlanEntityList = this.service.queryList(queryParam);
        List ids = trainPlanEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        Map<Long, String> projectName = trainPlanEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, FeedbackPlanEntity::getProjectName));
        Map<Long, String> unitName = trainPlanEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, FeedbackPlanEntity::getUnitName));
        param.getParams().put("pid", new Parameter("in", ids));
        IPage page = this.detailService.queryPage(param, false);
        List voList = BeanMapper.mapList((Iterable)page.getRecords(), FeedbackPlanDetailVO.class);
        voList.forEach(e -> {
            e.setProjectName((String)projectName.get(e.getPid()));
            e.setUnitName((String)unitName.get(e.getPid()));
        });
        CommonResponse byDefCategory = this.iDefdocApi.getDefDocByDefCode("feedback-category");
        CommonResponse byDefType = this.iDefdocApi.getDefDocByDefCode("feedback-type");
        CommonResponse byDefSource = this.iDefdocApi.getDefDocByDefCode("feedback-source");
        HashMap<String, String> map = new HashMap<String, String>();
        for (DefdocDetailVO datum : (List)byDefCategory.getData()) {
            map.put("category" + datum.getId(), datum.getName());
        }
        for (DefdocDetailVO datum : (List)byDefType.getData()) {
            map.put("type" + datum.getId(), datum.getName());
        }
        for (DefdocDetailVO datum : (List)byDefSource.getData()) {
            map.put("source" + datum.getId(), datum.getName());
        }
        for (FeedbackPlanDetailVO vo : voList) {
            vo.setFeedbackCategoryName((String)map.get("category" + vo.getFeedbackCategory()));
            vo.setFeedbackTypeName((String)map.get("type" + vo.getFeedbackType()));
            vo.setFeedbackSourceName((String)map.get("source" + vo.getFeedbackSource()));
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(voList);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("FeedbackPlanTZ-X-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFeedbackPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FeedbackPlanVO>> refFeedbackPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FeedbackPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

