package com.ejianc.business.quality.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.quality.bean.QualityEventContentEntity;
/**
 * 质量事件
 * 
 * @author generator
 * 
 */
 @TableName("ejc_quality_event")
public class QualityEventEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="second_unit")
    private String secondUnit; // 二级单位
    @TableField(value="event_type")
    private String eventType; // 事件类型
    @TableField(value="register_date")
    private Date registerDate; // 登记日期
    @TableField(value="punish_type")
    private String punishType; // 处罚分类
    @TableField(value="punish_grade")
    private String punishGrade; // 处罚事件分级
    @TableField(value="event_mny")
    private BigDecimal eventMny; // 事件损失金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="employee_part")
    private String employeePart; // 经办部门
    @TableField(value="reward")
    private String reward; // 奖励描述
    @TableField(value="quality_problem")
    private String qualityProblem; // 质量问题描述
    @TableField(value="measure")
    private String measure; // 纠正和预防措施/实践描述
    @TableField(value="punish_event")
    private String punishEvent; // 处罚情况(经济处罚与行政处罚)其他
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码

    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父工程ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 夫工程名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 夫工程编码
    @TableField(value="org_id")
    private Long orgId; // 工程ID
    @TableField(value="org_name")
    private String orgName; // 工程名称
    @TableField(value="org_code")
    private String orgCode; // 工程编码
    @TableField(value="source_id")
    private Long sourceId; // 来源id

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="qualityEventContentService",pidName = "mid")
    private List<QualityEventContentEntity> detailList = new ArrayList<>(); // 质量事件子表
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getSecondUnit() {
        return secondUnit;
    }

    public void setSecondUnit(String secondUnit) {
        this.secondUnit = secondUnit;
    }
    public String getEventType() {
        return eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }
    public Date getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }
    public String getPunishType() {
        return punishType;
    }

    public void setPunishType(String punishType) {
        this.punishType = punishType;
    }
    public String getPunishGrade() {
        return punishGrade;
    }

    public void setPunishGrade(String punishGrade) {
        this.punishGrade = punishGrade;
    }
    public BigDecimal getEventMny() {
        return eventMny;
    }

    public void setEventMny(BigDecimal eventMny) {
        this.eventMny = eventMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeePart() {
        return employeePart;
    }

    public void setEmployeePart(String employeePart) {
        this.employeePart = employeePart;
    }
    public String getReward() {
        return reward;
    }

    public void setReward(String reward) {
        this.reward = reward;
    }
    public String getQualityProblem() {
        return qualityProblem;
    }

    public void setQualityProblem(String qualityProblem) {
        this.qualityProblem = qualityProblem;
    }
    public String getMeasure() {
        return measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }
    public String getPunishEvent() {
        return punishEvent;
    }

    public void setPunishEvent(String punishEvent) {
        this.punishEvent = punishEvent;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public List<QualityEventContentEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<QualityEventContentEntity> detailList) {
        this.detailList = detailList;
    }
}
