package com.ejianc.business.quality.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 质量培训
 * 
 * @author generator
 * 
 */
public class QualityTrainVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date trainDate; // 培训日期
//    private String belongOrg; // 所属组织
//    private Long belongOrgId; // 所属组织id
    private String className; // 课程名称
    private Long speakId; // 主讲人ID
    private String speakName; // 主讲人
    private Integer participantNum; // 参与人数
    private BigDecimal money; // 经费
    private String content; // 具体内容
    private Long orgId; // 组织id
    private String orgCode; // 组织code
    private String orgName; // 组织名称
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private String employeePart; // 经办人部门
    private String billStateName;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getTrainDate() {
        return trainDate;
    }

    public void setTrainDate(Date trainDate) {
        this.trainDate = trainDate;
    }
//    public String getBelongOrg() {
//        return belongOrg;
//    }
//
//    public void setBelongOrg(String belongOrg) {
//        this.belongOrg = belongOrg;
//    }
//    public Long getBelongOrgId() {
//        return belongOrgId;
//    }
//
//    public void setBelongOrgId(Long belongOrgId) {
//        this.belongOrgId = belongOrgId;
//    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSpeakId() {
        return speakId;
    }
    @ReferDeserialTransfer
    public void setSpeakId(Long speakId) {
        this.speakId = speakId;
    }
    public String getSpeakName() {
        return speakName;
    }

    public void setSpeakName(String speakName) {
        this.speakName = speakName;
    }
    public Integer getParticipantNum() {
        return participantNum;
    }

    public void setParticipantNum(Integer participantNum) {
        this.participantNum = participantNum;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeePart() {
        return employeePart;
    }

    public void setEmployeePart(String employeePart) {
        this.employeePart = employeePart;
    }
    
}
