/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.safety.service.impl;

import com.ejianc.business.safety.bean.SafetySceneDailyEntity;
import com.ejianc.business.safety.mapper.SafetySceneDailyMapper;
import com.ejianc.business.safety.service.ISafetySceneDailyService;
import com.ejianc.business.safety.service.SafetyCheckMessageService;
import com.ejianc.business.scene.util.NoticeEnum;
import com.ejianc.business.scene.vo.SceneDailyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="safetySceneDailyService")
public class SafetySceneDailyServiceImpl
extends BaseServiceImpl<SafetySceneDailyMapper, SafetySceneDailyEntity>
implements ISafetySceneDailyService {
    @Autowired
    private SafetyCheckMessageService safetyCheckMessageService;

    @Override
    public void checkSubmitHandle(Long billId) {
        if (billId != null) {
            SafetySceneDailyEntity sceneDailyEntity = (SafetySceneDailyEntity)((Object)this.selectById(billId));
            String notifRelevantId = sceneDailyEntity.getNotifRelevantId();
            SceneDailyVO vo = (SceneDailyVO)BeanMapper.map((Object)((Object)sceneDailyEntity), SceneDailyVO.class);
            if (StringUtils.isNotBlank((CharSequence)notifRelevantId)) {
                String[] notifRelevant = notifRelevantId.split(",");
                vo.setMsgNum(Integer.valueOf(0));
                vo.setMsgBillCode(vo.getBillCode());
                vo.setMsgId(vo.getId());
                this.safetyCheckMessageService.sendDailyMsg(vo, notifRelevant, NoticeEnum.CHECK_Detail_COMMIT_PASS_REVIEW);
            }
        }
    }
}

