package com.ejianc.foundation.report.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * @author CJ
 * @Description: 筛选条件
 * @date 2020/10/28 9:47
 */
public class ConditionVO extends BaseVO {

    private static final long serialVersionUID = 3712785117890615189L;

    /**
     * 行唯一标识
     */
    private String rowId;
    /**
     * 类型
     */
    private String label;
    /**
     * 键值（筛选使用的过滤字段）
     */
    private String rowKey;
    /**
     * 筛选条件名称
     */
    private String title;
    /**
     * 输入类型：
     *  selfDefine：自定义字段
     *  enumSelect：档案
     *  referSelect：参照
     *  dateSelect：固定日期选择
     *  dateInSelect：日期区间选择
     *  moneyInInput：金额区间选择
     *  addressMap：地址选择
     *
     */
    private String inputType;

    /**
     * 档案编码/参照编码,输入类型为参照或档案时生效
     */
    private String referCode;
    /**
     * 是否禁用
     */
    private Boolean disabled;
    /**
     * 父Id
     */
    private String parentId;

    /**
     * 报表Id
     */
    private Long tblId;

    public String getRowId() {
        return rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getRowKey() {
        return rowKey;
    }

    public void setRowKey(String rowKey) {
        this.rowKey = rowKey;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInputType() {
        return inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public String getReferCode() {
        return referCode;
    }

    public void setReferCode(String referCode) {
        this.referCode = referCode;
    }

    public Boolean getDisabled() {
        return disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Long getTblId() {
        return tblId;
    }

    public void setTblId(Long tblId) {
        this.tblId = tblId;
    }
}
