package com.ejianc.business.payer.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.payer.vo.payerRecordDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 缴纳员工明细记录表主实体
 * 
 * @author generator
 * 
 */
public class payerRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long standardId; // 申请标准表Id
    private String standardCode; // 申请标准表code
    private String standardName; // 申请标准表名称
    private Long orgId; // 申请组织Id
    private String orgName; // 申请组织名称
    private String orgCode; // 申请组织编码
    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private Date belongYear; // 所属年度
    private BigDecimal riskDepositMny; // 风险金缴纳金额
    private BigDecimal totalPayerMny; // 员工应缴纳金额
    private Long employeeId; // 经办人id（申请人）
    private String employeeName; // 经办人名称（申请人）
    private Long departmentId; // 经办人部门id
    private String departmentName; // 经办人部门
    private String memo; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectDate; // 生效日期
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    private Long changeId; // 变更主键
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private BigDecimal beforeChangePayerMny; // 变更前缴纳金额
    private BigDecimal changingPayerMny; // 变更中缴纳金额
    private Long directPayerId; // 直管部缴纳员工明细id（用于数据引用）
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private String riskDepositType; // 风险保证金类型(directDept-直管部、projectDept-项目部)

    private BigDecimal baseMny; //初始版本金额
    private Long changeEmployeeId; // 变更经办人id
    private String changeEmployeeName; // 变更经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeEffectDate; // 变更生效日期
    private Date mainPayerId; // 主缴纳员工明细表id
    
    private List<payerRecordDetailVO> detailList = new ArrayList<>(); // 缴纳员工明细记录表子实体

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getStandardId() {
        return standardId;
    }

    public void setStandardId(Long standardId) {
        this.standardId = standardId;
    }
    public String getStandardCode() {
        return standardCode;
    }

    public void setStandardCode(String standardCode) {
        this.standardCode = standardCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Date getBelongYear() {
        return belongYear;
    }

    public void setBelongYear(Date belongYear) {
        this.belongYear = belongYear;
    }
    public BigDecimal getRiskDepositMny() {
        return riskDepositMny;
    }

    public void setRiskDepositMny(BigDecimal riskDepositMny) {
        this.riskDepositMny = riskDepositMny;
    }
    public BigDecimal getTotalPayerMny() {
        return totalPayerMny;
    }

    public void setTotalPayerMny(BigDecimal totalPayerMny) {
        this.totalPayerMny = totalPayerMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public BigDecimal getBeforeChangePayerMny() {
        return beforeChangePayerMny;
    }

    public void setBeforeChangePayerMny(BigDecimal beforeChangePayerMny) {
        this.beforeChangePayerMny = beforeChangePayerMny;
    }
    public BigDecimal getChangingPayerMny() {
        return changingPayerMny;
    }

    public void setChangingPayerMny(BigDecimal changingPayerMny) {
        this.changingPayerMny = changingPayerMny;
    }
    public Long getDirectPayerId() {
        return directPayerId;
    }

    public void setDirectPayerId(Long directPayerId) {
        this.directPayerId = directPayerId;
    }
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getRiskDepositType() {
        return riskDepositType;
    }

    public void setRiskDepositType(String riskDepositType) {
        this.riskDepositType = riskDepositType;
    }


    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }

    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }

    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }

    public List<payerRecordDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<payerRecordDetailVO> detailList) {
        this.detailList = detailList;
    }

    public String getStandardName() {
        return standardName;
    }

    public void setStandardName(String standardName) {
        this.standardName = standardName;
    }

    public Date getChangeEffectDate() {
        return changeEffectDate;
    }

    public void setChangeEffectDate(Date changeEffectDate) {
        this.changeEffectDate = changeEffectDate;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getMainPayerId() {
        return mainPayerId;
    }

    public void setMainPayerId(Date mainPayerId) {
        this.mainPayerId = mainPayerId;
    }
}
