/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.standard.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.standard.bean.StandardChangeEntity;
import com.ejianc.business.standard.bean.StandardDetailEntity;
import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.bean.StandardRecordEntity;
import com.ejianc.business.standard.service.IStandardChangeService;
import com.ejianc.business.standard.service.IStandardRecordService;
import com.ejianc.business.standard.service.IStandardService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="standardChange")
public class StandardChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IStandardChangeService changeService;
    @Autowired
    private IStandardService standardService;
    @Autowired
    private IStandardRecordService recordService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return this.changeService.effectiveSaveWriteStandard(billId, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    private CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        StandardChangeEntity changeEntity = (StandardChangeEntity)((Object)this.changeService.selectById(billId));
        changeEntity.setEffectDate(null);
        this.changeService.saveOrUpdate((Object)changeEntity);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("main_standard_id", new Parameter("eq", (Object)changeEntity.getMainStandardId()));
        queryParam.getParams().put("change_id", new Parameter("eq", (Object)billId));
        List recordEntityList = this.recordService.queryList(queryParam);
        this.logger.info("\u67e5\u8be2\u5230\u6807\u51c6\u8868\u7684\u8bb0\u5f55\u8868\u96c6\u5408{}", (Object)JSONObject.toJSONString((Object)recordEntityList));
        if (CollectionUtils.isNotEmpty((Collection)recordEntityList) && null != recordEntityList.get(0)) {
            this.logger.info("\u67e5\u8be2\u5230\u6807\u51c6\u8868\u7684\u8bb0\u5f55\u8868{}", (Object)JSONObject.toJSONString(recordEntityList.get(0)));
            StandardRecordEntity recordEntity = (StandardRecordEntity)((Object)recordEntityList.get(0));
            StandardEntity standardEntity = (StandardEntity)((Object)BeanMapper.map((Object)((Object)recordEntity), StandardEntity.class));
            this.logger.info("\u64a4\u56de\u66f4\u65b0\u524d\u6807\u51c6\u8868\u6570\u636e,standardEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)standardEntity)));
            standardEntity.setId(changeEntity.getMainStandardId());
            if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
                recordEntity.getDetailList().forEach(vo -> vo.setId(vo.getSrcTableId()));
            }
            standardEntity.setDetailList(BeanMapper.mapList(recordEntity.getDetailList(), StandardDetailEntity.class));
            this.standardService.saveOrUpdate((Object)standardEntity, false);
            this.recordService.removeById(recordEntity.getId(), false);
            this.logger.info("\u64a4\u56de\u66f4\u65b0\u6807\u51c6\u8868\u6570\u636e\u6210\u529f,standardEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)standardEntity)));
        }
        return CommonResponse.success((String)"\u6267\u884c\u53d8\u66f4\u5355\u64a4\u56de\u56de\u8c03\u903b\u8f91\u6210\u529f\uff01");
    }
}

