/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.standard.service.impl;

import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.standard.bean.StandardDetailEntity;
import com.ejianc.business.standard.mapper.StandardDetailMapper;
import com.ejianc.business.standard.service.IStandardDetailService;
import com.ejianc.business.standard.vo.StandardDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="standardDetailService")
public class StandardDetailServiceImpl
extends BaseServiceImpl<StandardDetailMapper, StandardDetailEntity>
implements IStandardDetailService {
    @Autowired
    private IContractPoolApi contractPoolApi;

    @Override
    public CommonResponse<List<StandardDetailVO>> queryProjectData(String projectIds, String standardId) {
        List<String> ids = Arrays.asList(projectIds.split(","));
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("projectId", new Parameter("in", ids));
            queryParam.getParams().put("standardId", new Parameter("ne", (Object)standardId));
            List detailList = super.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                String inUseProject = "";
                for (StandardDetailEntity detail : detailList) {
                    inUseProject = inUseProject + detail.getProjectName() + ",";
                }
                if (inUseProject.length() > 1) {
                    inUseProject = inUseProject.substring(0, inUseProject.length() - 1);
                }
                return CommonResponse.error((String)("\u9879\u76ee\uff1a" + inUseProject + "\u5df2\u88ab\u5176\u4ed6\u6807\u51c6\u8868\u5f15\u7528\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9879\u76ee\uff01"));
            }
            QueryParam contractQuery = new QueryParam();
            contractQuery.getParams().put("projectId", new Parameter("in", ids));
            contractQuery.getParams().put("sourceType", new Parameter("eq", (Object)"CONTRACT_TYPE"));
            CommonResponse resultData = this.contractPoolApi.queryList(contractQuery);
            ArrayList<StandardDetailVO> standardDetailVOList = new ArrayList<StandardDetailVO>();
            if (resultData.isSuccess()) {
                StandardDetailVO standardDetailVO;
                List contractPoolVOList = (List)resultData.getData();
                if (CollectionUtils.isNotEmpty((Collection)contractPoolVOList)) {
                    for (Object contractPoolVO : contractPoolVOList) {
                        standardDetailVO = new StandardDetailVO();
                        standardDetailVO.setSourceId(contractPoolVO.getProjectId());
                        standardDetailVO.setProjectId(contractPoolVO.getProjectId());
                        standardDetailVO.setProjectCode(contractPoolVO.getProjectCode());
                        standardDetailVO.setProjectName(contractPoolVO.getProjectName());
                        standardDetailVO.setContractCode(contractPoolVO.getContractCode());
                        standardDetailVO.setContractId(contractPoolVO.getContractId());
                        standardDetailVO.setContractMny(contractPoolVO.getContractMny());
                        standardDetailVO.setContractName(contractPoolVO.getContractName());
                        standardDetailVOList.add(standardDetailVO);
                    }
                }
                if (ids.size() != standardDetailVOList.size()) {
                    if (CollectionUtils.isNotEmpty(standardDetailVOList)) {
                        Map standardDetailVOMap = standardDetailVOList.stream().collect(Collectors.toMap(StandardDetailVO::getProjectId, Function.identity(), (key1, key2) -> key2));
                        for (String projectId : ids) {
                            if (standardDetailVOMap.containsKey(Long.valueOf(projectId))) continue;
                            StandardDetailVO standardDetailVO2 = new StandardDetailVO();
                            standardDetailVO2.setProjectId(Long.valueOf(projectId));
                            standardDetailVO2.setSourceId(Long.valueOf(projectId));
                            standardDetailVOList.add(standardDetailVO2);
                        }
                    } else {
                        for (String projectId : ids) {
                            standardDetailVO = new StandardDetailVO();
                            standardDetailVO.setProjectId(Long.valueOf(projectId));
                            standardDetailVO.setSourceId(Long.valueOf(projectId));
                            standardDetailVOList.add(standardDetailVO);
                        }
                    }
                }
            } else {
                for (String projectId : ids) {
                    StandardDetailVO standardDetailVO = new StandardDetailVO();
                    standardDetailVO.setProjectId(Long.valueOf(projectId));
                    standardDetailVO.setSourceId(Long.valueOf(projectId));
                    standardDetailVOList.add(standardDetailVO);
                }
            }
            return CommonResponse.success((String)"\u9009\u62e9\u9879\u76ee\u53ef\u4ee5\u4f7f\u7528\uff01", standardDetailVOList);
        }
        return CommonResponse.error((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u9879\u76eeid\u53c2\u6570\uff01");
    }
}

