package com.ejianc.business.repay.service;

import com.ejianc.business.repay.bean.RepayEntity;
import com.ejianc.business.repay.vo.RepayVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 风险金退还表
 *
 * @author baipengyan
 */
public interface IRepayService extends IBaseService<RepayEntity> {

	/**
	 * 是否是最新单据
	 *
	 * @param billId 单据id
	 * @param userId 用户id
	 * @param orgId  组织id
	 *
	 * @return 是否是最新单据
	 */
	boolean isLatestBill(Long billId, Long userId, Long orgId);

	/**
	 * 风险金退还：批量确认
	 *
	 * @param repays 要确认的单据信息
	 */
	void batchConfirm(List<RepayVO> repays);

	/**
	 * 校验：一个员工+员工明细只可以有一个未生效的单据（退还+调动+缴纳）
	 *
	 * @param userId 用户id
	 * @param orgId  组织id
	 * @param info   缴纳/退还
	 */
	CommonResponse<String> checkBeforeSave(Long userId, Long orgId, String info);

	/**
	 * 校验是否可以调动
	 *
	 * @param userId        用户id
	 * @param transferOrgId 调动组织id
	 *
	 * @return 是否可以调动
	 */
	Boolean checkTransferOrg(Long userId, Long transferOrgId);
}
