/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.standard.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.standard.bean.StandardDetailEntity;
import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.business.standard.mapper.StandardMapper;
import com.ejianc.business.standard.service.IStandardService;
import com.ejianc.business.standard.vo.StandardDetailVO;
import com.ejianc.business.standard.vo.StandardVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="standardService")
public class StandardServiceImpl
extends BaseServiceImpl<StandardMapper, StandardEntity>
implements IStandardService {
    private static final String DIRECT_BILL_CODE = "DIRECT_DEPT_PAYER";
    private static final String PROJECT_BILL_CODE = "PROJECT_DEPT_PAYER";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public Map<String, Object> countSumMny(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = StandardServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(risk_deposit_mny) as totalPayMny, sum(base_mny) as totalBasePayMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("totalPayMny", 0);
            resp.put("totalBasePayMny", 0);
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public StandardVO insertOrUpdate(StandardVO standardVO) {
        StandardEntity entity = (StandardEntity)((Object)BeanMapper.map((Object)standardVO, StandardEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)("directDept".equals(standardVO.getRiskDepositType()) ? DIRECT_BILL_CODE : PROJECT_BILL_CODE), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)standardVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u6807\u51c6\u8868\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u6807\u51c6\u8868\u5355\u636e\u7f16\u7801\u5931\u8d25: {}", (Object)billCode.getMsg());
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setBeforeChangeRiskDepositMny(standardVO.getRiskDepositMny());
            entity.setChangeVersion(0);
            entity.setBaseMny(standardVO.getRiskDepositMny());
        } else {
            StandardEntity oldEntity = (StandardEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (oldEntity != null && !oldEntity.getOrgId().equals(entity.getOrgId())) {
                for (StandardDetailEntity oldDetail : oldEntity.getDetailList()) {
                    oldDetail.setRowState("del");
                }
                entity.getDetailList().addAll(oldEntity.getDetailList());
            }
        }
        super.saveOrUpdate((Object)entity, false);
        StandardVO returnVO = (StandardVO)BeanMapper.map((Object)super.selectById((Serializable)entity.getId()), StandardVO.class);
        returnVO = this.transformWan(returnVO);
        return returnVO;
    }

    @Override
    public CommonResponse<String> queryProjectDeleteFlag(String projectIds) {
        List<String> ids = Arrays.asList(projectIds.split(","));
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("projectId", new Parameter("in", ids));
            List standardEntityList = super.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)standardEntityList)) {
                String inUseProject = "";
                for (StandardEntity standardEntity : standardEntityList) {
                    inUseProject = inUseProject + standardEntity.getProjectName() + ",";
                }
                if (inUseProject.length() > 1) {
                    inUseProject = inUseProject.substring(0, inUseProject.length() - 1);
                }
                return CommonResponse.error((String)("\u9879\u76ee\uff1a" + inUseProject + "\u5df2\u88ab\u9879\u76ee\u90e8\u6807\u51c6\u8868\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\uff01"));
            }
        }
        return CommonResponse.success((String)"\u9879\u76ee\u672a\u88ab\u9879\u76ee\u90e8\u6807\u51c6\u8868\u5f15\u7528\uff0c\u53ef\u4ee5\u5220\u9664\uff01");
    }

    @Override
    public StandardVO transformWan(StandardVO vo) {
        if (null != vo.getRiskDepositPayableMny()) {
            vo.setRiskDepositPayableMnyWan(vo.getRiskDepositPayableMny().divide(new BigDecimal(10000)));
        } else {
            vo.setRiskDepositPayableMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getRiskDepositMny()) {
            vo.setRiskDepositMnyWan(vo.getRiskDepositMny().divide(new BigDecimal(10000)));
        } else {
            vo.setRiskDepositMnyWan(BigDecimal.ZERO);
        }
        if ("directDept".equals(vo.getRiskDepositType())) {
            if (null != vo.getOutputMny()) {
                vo.setOutputMnyWan(vo.getOutputMny().divide(new BigDecimal(10000)));
            } else {
                vo.setOutputMnyWan(BigDecimal.ZERO);
            }
            if (null != vo.getLastYearContractMny()) {
                vo.setLastYearContractMnyWan(vo.getLastYearContractMny().divide(new BigDecimal(10000)));
            } else {
                vo.setLastYearContractMnyWan(BigDecimal.ZERO);
            }
            if (null != vo.getLastYearOutputMny()) {
                vo.setLastYearOutputMnyWan(vo.getLastYearOutputMny().divide(new BigDecimal(10000)));
            } else {
                vo.setLastYearOutputMnyWan(BigDecimal.ZERO);
            }
            if (null != vo.getWorkerCongressContractMny()) {
                vo.setWorkerCongressContractMnyWan(vo.getWorkerCongressContractMny().divide(new BigDecimal(10000)));
            } else {
                vo.setWorkerCongressContractMnyWan(BigDecimal.ZERO);
            }
        } else if (null != vo.getContractMny()) {
            vo.setContractMnyWan(vo.getContractMny().divide(new BigDecimal(10000)));
        } else {
            vo.setContractMnyWan(BigDecimal.ZERO);
        }
        List detailVOList = vo.getDetailList();
        for (StandardDetailVO detail : detailVOList) {
            if (null != detail.getContractMny()) {
                detail.setContractMnyWan(detail.getContractMny().divide(new BigDecimal(10000)));
                continue;
            }
            detail.setContractMnyWan(BigDecimal.ZERO);
        }
        return vo;
    }
}

