package com.ejianc.business.pay.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author baipengyan
 * @date 2022/6/27
 * @description 风险金缴纳是否分期枚举
 */
public enum InstallmentFlagEnum {
	/**
	 * 否
	 */
	NO("0", "否"),
	/**
	 * 是
	 */
	YES("1", "是");
	private final String code;
	private final String name;

	InstallmentFlagEnum(String code, String name) {
		this.code = code;
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	private static Map<String, InstallmentFlagEnum> enumMap = new HashMap<>();

	static {
		enumMap = EnumSet.allOf(InstallmentFlagEnum.class).stream().collect(Collectors.toMap(InstallmentFlagEnum::getCode, Function.identity(), (k1, k2) -> k2));
	}

	public static InstallmentFlagEnum getEnumByCode(String code) {
		return enumMap.get(code);
	}
}
