package com.ejianc.business.collect.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cash.vo.CashCostVO;
import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.service.IStandardService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.collect.bean.CollectEntity;
import com.ejianc.business.collect.service.ICollectService;
import com.ejianc.business.collect.vo.CollectVO;

/**
 * 兑现计算汇总表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("collect")
public class CollectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IStandardService standardService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "COLLECT_CODE";//此处需要根据实际修改

    @Autowired
    private ICollectService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CollectVO> saveOrUpdate(@RequestBody CollectVO saveOrUpdateVO) {
    	CollectEntity entity = BeanMapper.map(saveOrUpdateVO, CollectEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	CollectVO vo = BeanMapper.map(entity, CollectVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CollectVO> queryDetail(Long id) {
    	CollectEntity entity = service.selectById(id);
    	CollectVO vo = BeanMapper.map(entity, CollectVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryCostMny 根据项目获取实际成本金额 / 校验是否有风险抵押金标准数据
     * @param projectId
     */
    @RequestMapping(value = "/queryCostMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CashCostVO> queryCostMny(Long projectId) {
        CashCostVO resVo = new CashCostVO();
        List<Integer> billList = new ArrayList<>();
        billList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        LambdaQueryWrapper<StandardEntity> lambda = Wrappers.<StandardEntity>lambdaQuery();
        lambda.eq(StandardEntity::getRiskDepositType, "projectDept");
        lambda.eq(StandardEntity::getProjectId, projectId);
        lambda.in(StandardEntity::getBillState,billList);
        List<StandardEntity> resList = standardService.list(lambda);
        if(CollectionUtils.isNotEmpty(resList)){
            resVo.setType(0);
        }else{
            resVo.setType(1);
        }
        return CommonResponse.success("查询详情数据成功！",resVo);
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CollectVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CollectVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CollectVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CollectVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<CollectEntity> page = service.queryPage(param,false);
        IPage<CollectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CollectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CollectEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Collect-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refCollectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CollectVO>> refCollectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("approveFlag", new Parameter(QueryParam.EQ, 0));//未引用
        List<Integer> billList = new ArrayList<>();
        billList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        param.getParams().put("billState", new Parameter(QueryParam.IN, billList));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, Long.valueOf(String.valueOf(_con.get("projectId")))));
            }
        }

        IPage<CollectEntity> page = service.queryPage(param,false);
        IPage<CollectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CollectVO.class));
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            pageData.getRecords().forEach(e->{
                BigDecimal aa = e.getShareProfitMny()==null?BigDecimal.ZERO:e.getShareProfitMny();
                e.setShareProfitMny(aa.divide(new BigDecimal(10000)));
            });
        }
        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
