package com.ejianc.business.payer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.payer.bean.PayerDetailEntity;
import com.ejianc.business.payer.service.IPayerDetailService;
import com.ejianc.business.payer.vo.*;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.payer.mapper.PayerMapper;
import com.ejianc.business.payer.bean.PayerEntity;
import com.ejianc.business.payer.service.IPayerService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 缴纳员工明细表主实体
 * 
 * @author generator
 * 
 */
@Service("payerService")
public class PayerServiceImpl extends BaseServiceImpl<PayerMapper, PayerEntity> implements IPayerService {
    private static final String DIRECT_BILL_CODE = "DIRECT_DEPT_PAYER";//直管部 风险金缴纳标准编码
    private static final String PROJECT_BILL_CODE = "PROJECT_DEPT_PAYER";//项目部 风险金缴纳标准编码


    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPayerDetailService payerDetailService;


    @Override
    public Map<String, Object> countSumMny(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(total_payer_mny) as totalPayMny, sum(base_mny) as totalBasePayMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("totalPayMny", 0);
            resp.put("totalBasePayMny", 0);
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PayerVO insertOrUpdate(PayerVO payerVO) {
        PayerEntity entity = BeanMapper.map(payerVO, PayerEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(("directDept").equals(payerVO.getRiskDepositType()) ? DIRECT_BILL_CODE : PROJECT_BILL_CODE, InvocationInfoProxy.getTenantid(),payerVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(!billCode.isSuccess()) {
                logger.error("保存标准表失败，自动生成标准表单据编码失败: {}", billCode.getMsg());
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setId(IdWorker.getId());
            entity.setBillCode(billCode.getData());
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            entity.setBeforeChangePayerMny(payerVO.getTotalPayerMny());
            entity.setChangeVersion(0);
            //设置子表字段
        }else {
            //如果切换标准表则把原来的缴纳人员都进行删除
            PayerEntity oldEntity = super.selectById(entity.getId());
            if (oldEntity != null && !oldEntity.getStandardId().equals(payerVO.getStandardId())){
                for (PayerDetailEntity oldDetail : oldEntity.getDetailList()) {
                    oldDetail.setRowState("del");
                }

                entity.getDetailList().addAll(oldEntity.getDetailList());
            }
        }

        List<PayerDetailEntity> payerDetailList = entity.getDetailList();
        for (PayerDetailEntity detail : payerDetailList) {
            if (null == detail.getPayerOrgId()){
                detail.setPayerId(entity.getId());
                detail.setPayerCode(entity.getBillCode());
                detail.setPayerName(entity.getBillCode());
                detail.setPayerOrgId(entity.getOrgId());
                detail.setPayerOrgCode(entity.getOrgCode());
                detail.setPayerOrgName(entity.getOrgName());
                if ("projectDept".equals(payerVO.getRiskDepositType())){
                    detail.setPayerProjectId(entity.getProjectId());
                    detail.setPayerProjectCode(entity.getProjectCode());
                    detail.setPayerProjectName(entity.getProjectName());
                    //项目部缴纳明细存项目信息
                    detail.setPayerProjectParentOrgId(entity.getProjectParentOrgId());
                    detail.setPayerProjectParentOrgCode(entity.getProjectParentOrgCode());
                    detail.setPayerProjectParentOrgName(entity.getProjectParentOrgName());
                }
                detail.setPayerRiskDepositType(entity.getRiskDepositType());
                detail.setPayerBelongYear(entity.getBelongYear());
                detail.setPeriodizationFlag(0);
                detail.setActualPayerScale(BigDecimal.ZERO);
            }
            detail.setPayerEmployeeId(entity.getEmployeeId());
            detail.setPayerEmployeeName(entity.getEmployeeName());
        }

        entity.setBaseMny(payerVO.getTotalPayerMny());
        super.saveOrUpdate(entity, false);
        PayerVO vo = BeanMapper.map(super.selectById(entity.getId()), PayerVO.class);
        vo = transformWan(vo);
        return vo;
    }

    /**
     * 将缴纳员工明细的页面相关金额转换成万元
     * 直管部缴纳金额（万元）、员工应缴纳金额（万元）、缴纳金额（万元）、实际缴纳金额（万元）、未缴纳金额（万元）
     * @param vo
     * @return
     */
    @Override
    public PayerVO transformWan(PayerVO vo) {
        if (null != vo.getTotalPayerMny()){
            vo.setTotalPayerMnyWan(vo.getTotalPayerMny().divide(new BigDecimal(10000)));
        }else {
            vo.setTotalPayerMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getRiskDepositMny()){
            vo.setRiskDepositMnyWan(vo.getRiskDepositMny().divide(new BigDecimal(10000)));
        }else {
            vo.setRiskDepositMnyWan(BigDecimal.ZERO);
        }
        List<PayerDetailVO> detailVOList = vo.getDetailList();
        for (PayerDetailVO detail : detailVOList) {
            if (null != detail.getPayerMny()){
                detail.setPayerMnyWan(detail.getPayerMny().divide(new BigDecimal(10000)));
            }else {
                detail.setPayerMnyWan(BigDecimal.ZERO);
            }
            if (null != detail.getActualPayerMny()){
                detail.setActualPayerMnyWan(detail.getActualPayerMny().divide(new BigDecimal(10000)));
            }else {
                detail.setActualPayerMnyWan(BigDecimal.ZERO);
            }
            if (null != detail.getRemainderPayerMny()){
                detail.setRemainderPayerMnyWan(detail.getRemainderPayerMny().divide(new BigDecimal(10000)));
            }else {
                detail.setRemainderPayerMnyWan(BigDecimal.ZERO);
            }
        }
        return vo;
    }

    @Override
    public List<EmployeeMnyVO> selectPage(Page pages, QueryWrapper queryWrapper,List<Long> orgIdList) {
        return baseMapper.pageList(pages,queryWrapper,orgIdList);
    }

    @Override
    public EmployeeMnyVO queryEmployeeMnyDetail(Long employeeId) {
        EmployeeMnyVO employeeMnyVO = new EmployeeMnyVO();
        employeeMnyVO.setEmployeeId(employeeId);
        List<EmployeePayVO> employeePayList = baseMapper.queryPayList(employeeId);
        if(CollectionUtils.isNotEmpty(employeePayList)){
            employeeMnyVO.setEmployeePayList(employeePayList);
        }
        List<EmployeeShareVO> employeeShareList = baseMapper.queryShareList(employeeId);
        if(CollectionUtils.isNotEmpty(employeeShareList)){
            employeeMnyVO.setEmployeeShareList(employeeShareList);
        }
        return employeeMnyVO;
    }
}
