/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.payer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.payer.bean.PayerDetailEntity;
import com.ejianc.business.payer.bean.PayerEntity;
import com.ejianc.business.payer.mapper.PayerMapper;
import com.ejianc.business.payer.service.IPayerDetailService;
import com.ejianc.business.payer.service.IPayerService;
import com.ejianc.business.payer.vo.EmployeeMnyVO;
import com.ejianc.business.payer.vo.EmployeePayVO;
import com.ejianc.business.payer.vo.EmployeeShareVO;
import com.ejianc.business.payer.vo.PayerDetailVO;
import com.ejianc.business.payer.vo.PayerVO;
import com.ejianc.business.payer.vo.ReportPayerDetailVO;
import com.ejianc.business.payer.vo.ReportPayerRecordVO;
import com.ejianc.business.payer.vo.ReportPayerShareVO;
import com.ejianc.business.payer.vo.ReportPayerVO;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="payerService")
public class PayerServiceImpl
extends BaseServiceImpl<PayerMapper, PayerEntity>
implements IPayerService {
    private static final String DIRECT_BILL_CODE = "DIRECT_DEPT_PAYER";
    private static final String PROJECT_BILL_CODE = "PROJECT_DEPT_PAYER";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPayerDetailService payerDetailService;

    @Override
    public Map<String, Object> countSumMny(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = PayerServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(total_payer_mny) as totalPayMny, sum(base_mny) as totalBasePayMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("totalPayMny", 0);
            resp.put("totalBasePayMny", 0);
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PayerVO insertOrUpdate(PayerVO payerVO) {
        PayerEntity entity = (PayerEntity)((Object)BeanMapper.map((Object)payerVO, PayerEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)("directDept".equals(payerVO.getRiskDepositType()) ? DIRECT_BILL_CODE : PROJECT_BILL_CODE), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)payerVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u6807\u51c6\u8868\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u6807\u51c6\u8868\u5355\u636e\u7f16\u7801\u5931\u8d25: {}", (Object)billCode.getMsg());
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setId(IdWorker.getId());
            entity.setBillCode((String)billCode.getData());
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setBeforeChangePayerMny(payerVO.getTotalPayerMny());
            entity.setChangeVersion(0);
        } else {
            PayerEntity oldEntity = (PayerEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (oldEntity != null && !oldEntity.getStandardId().equals(payerVO.getStandardId())) {
                for (PayerDetailEntity oldDetail : oldEntity.getDetailList()) {
                    oldDetail.setRowState("del");
                }
                entity.getDetailList().addAll(oldEntity.getDetailList());
            }
        }
        List<PayerDetailEntity> payerDetailList = entity.getDetailList();
        for (PayerDetailEntity detail : payerDetailList) {
            if (null == detail.getPayerOrgId()) {
                detail.setPayerId(entity.getId());
                detail.setPayerCode(entity.getBillCode());
                detail.setPayerName(entity.getBillCode());
                detail.setPayerOrgId(entity.getOrgId());
                detail.setPayerOrgCode(entity.getOrgCode());
                detail.setPayerOrgName(entity.getOrgName());
                if ("projectDept".equals(payerVO.getRiskDepositType())) {
                    detail.setPayerProjectId(entity.getProjectId());
                    detail.setPayerProjectCode(entity.getProjectCode());
                    detail.setPayerProjectName(entity.getProjectName());
                    detail.setPayerProjectParentOrgId(entity.getProjectParentOrgId());
                    detail.setPayerProjectParentOrgCode(entity.getProjectParentOrgCode());
                    detail.setPayerProjectParentOrgName(entity.getProjectParentOrgName());
                }
                detail.setPayerRiskDepositType(entity.getRiskDepositType());
                detail.setPayerBelongYear(entity.getBelongYear());
                detail.setPeriodizationFlag(0);
                detail.setActualPayerScale(BigDecimal.ZERO);
            }
            detail.setPayerEmployeeId(entity.getEmployeeId());
            detail.setPayerEmployeeName(entity.getEmployeeName());
        }
        entity.setBaseMny(payerVO.getTotalPayerMny());
        super.saveOrUpdate((Object)entity, false);
        PayerVO vo = (PayerVO)BeanMapper.map((Object)super.selectById((Serializable)entity.getId()), PayerVO.class);
        vo = this.transformWan(vo);
        return vo;
    }

    @Override
    public PayerVO transformWan(PayerVO vo) {
        if (null != vo.getTotalPayerMny()) {
            vo.setTotalPayerMnyWan(vo.getTotalPayerMny().divide(new BigDecimal(10000)));
        } else {
            vo.setTotalPayerMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getRiskDepositMny()) {
            vo.setRiskDepositMnyWan(vo.getRiskDepositMny().divide(new BigDecimal(10000)));
        } else {
            vo.setRiskDepositMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getTotalActualPayerMny()) {
            vo.setTotalActualPayerMnyWan(vo.getTotalActualPayerMny().divide(new BigDecimal(10000)));
        } else {
            vo.setTotalActualPayerMnyWan(BigDecimal.ZERO);
        }
        List detailVOList = vo.getDetailList();
        for (PayerDetailVO detail : detailVOList) {
            if (null != detail.getPayerMny()) {
                detail.setPayerMnyWan(detail.getPayerMny().divide(new BigDecimal(10000)));
            } else {
                detail.setPayerMnyWan(BigDecimal.ZERO);
            }
            if (null != detail.getActualPayerMny()) {
                detail.setActualPayerMnyWan(detail.getActualPayerMny().divide(new BigDecimal(10000)));
            } else {
                detail.setActualPayerMnyWan(BigDecimal.ZERO);
            }
            if (null != detail.getRemainderPayerMny()) {
                detail.setRemainderPayerMnyWan(detail.getRemainderPayerMny().divide(new BigDecimal(10000)));
                continue;
            }
            detail.setRemainderPayerMnyWan(BigDecimal.ZERO);
        }
        return vo;
    }

    @Override
    public List<EmployeeMnyVO> selectPage(Page pages, QueryWrapper queryWrapper, List<Long> orgIdList) {
        return ((PayerMapper)this.baseMapper).pageList(pages, queryWrapper, orgIdList);
    }

    @Override
    public EmployeeMnyVO queryEmployeeMnyDetail(Long employeeId) {
        List<EmployeeShareVO> employeeShareList;
        EmployeeMnyVO employeeMnyVO = new EmployeeMnyVO();
        employeeMnyVO.setEmployeeId(employeeId);
        List<EmployeePayVO> employeePayList = ((PayerMapper)this.baseMapper).queryPayList(employeeId);
        if (CollectionUtils.isNotEmpty(employeePayList)) {
            employeeMnyVO.setEmployeePayList(employeePayList);
        }
        if (CollectionUtils.isNotEmpty(employeeShareList = ((PayerMapper)this.baseMapper).queryShareList(employeeId))) {
            employeeMnyVO.setEmployeeShareList(employeeShareList);
        }
        return employeeMnyVO;
    }

    @Override
    public List<ReportPayerVO> selectReportPayerPage(Page<ReportPayerVO> pages, QueryWrapper queryWrapper, List<Long> orgIdList, String riskDepositType) {
        return ((PayerMapper)this.baseMapper).selectReportPayerPage(pages, queryWrapper, orgIdList, riskDepositType);
    }

    @Override
    public ReportPayerVO queryReportPayerDetail(Long payerId, String riskDepositType) {
        List detailList;
        List<Long> payerDetailIdList;
        List<ReportPayerDetailVO> leavePayerDetailIdList;
        Object leaveIdList;
        ReportPayerVO reportPayerVO = new ReportPayerVO();
        reportPayerVO.setId(payerId);
        List<ReportPayerDetailVO> reportPayerDetailList = ((PayerMapper)this.baseMapper).selectReportPayerDetailList(payerId, riskDepositType, null);
        reportPayerVO.setDetailList(reportPayerDetailList);
        if (CollectionUtils.isNotEmpty(reportPayerDetailList) && CollectionUtils.isNotEmpty(leaveIdList = (leavePayerDetailIdList = ((PayerMapper)this.baseMapper).selectLeavePayerDetailList(payerId, payerDetailIdList = reportPayerDetailList.stream().map(BaseVO::getId).collect(Collectors.toList()))).stream().map(BaseVO::getId).collect(Collectors.toList()))) {
            List<ReportPayerDetailVO> leavePayerDetailList = ((PayerMapper)this.baseMapper).selectReportPayerDetailList(payerId, riskDepositType, (List<Long>)leaveIdList);
            reportPayerVO.getDetailList().addAll(leavePayerDetailList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(detailList = reportPayerVO.getDetailList()))) {
            BigDecimal totalShareOrgMny = detailList.stream().filter(p -> p.getShareOrgMny() != null).map(ReportPayerDetailVO::getShareOrgMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.logger.info("totalShareOrgMny-{}", (Object)totalShareOrgMny);
            this.logger.info("detailList-{}", (Object)JSONObject.toJSONString((Object)reportPayerVO.getDetailList()));
            for (ReportPayerDetailVO detailVO : reportPayerVO.getDetailList()) {
                detailVO.setShareOrgMnyRatio(totalShareOrgMny.compareTo(BigDecimal.ZERO) > 0 ? detailVO.getShareOrgMny().multiply(new BigDecimal(100)).divide(totalShareOrgMny, 2, 4) : BigDecimal.ZERO);
                detailVO.setPayerMnyWan(detailVO.getPayerMnyWan().divide(new BigDecimal(10000)));
                detailVO.setActualPayerMnyWan(detailVO.getActualPayerMnyWan().divide(new BigDecimal(10000)));
                detailVO.setRepayTaxMny(detailVO.getRepayTaxMny().divide(new BigDecimal(10000)));
                detailVO.setActualPayerMny(detailVO.getActualPayerMny().divide(new BigDecimal(10000)));
            }
        }
        List<ReportPayerRecordVO> reportPayerRecordList = ((PayerMapper)this.baseMapper).selectReportPayerRecordList(payerId);
        reportPayerVO.setRecordList(reportPayerRecordList);
        List<ReportPayerShareVO> reportPayerShareList = "directDept".equals(riskDepositType) ? ((PayerMapper)this.baseMapper).selectReportPayerShareOrgList(payerId) : ((PayerMapper)this.baseMapper).selectReportPayerShareDeptList(payerId);
        reportPayerVO.setShareList(reportPayerShareList);
        return reportPayerVO;
    }

    @Override
    public void updateActualPayerMny(List<Long> payerIdList) {
        this.logger.info("\u6279\u91cf\u66f4\u65b0\u5458\u5de5\u660e\u7ec6\u8868\u5b9e\u53d1\u91d1\u989did\u5217\u8868\uff1apayerIdList-{}", (Object)JSONObject.toJSONString(payerIdList));
        if (CollectionUtils.isNotEmpty(payerIdList)) {
            for (Long payerId : payerIdList) {
                PayerEntity payerEntity = (PayerEntity)((Object)super.selectById((Serializable)payerId));
                List<PayerDetailEntity> payerDetailEntityList = payerEntity.getDetailList();
                BigDecimal totalActualPayerMny = payerDetailEntityList.stream().filter(e -> null != e.getActualPayerMny()).map(PayerDetailEntity::getActualPayerMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.logger.info("\u83b7\u53d6\u5355\u636e-{}-\u5b9e\u9645\u91d1\u989d\u6c47\u603b\uff1a{}", (Object)payerEntity.getId(), (Object)totalActualPayerMny);
                payerEntity.setTotalActualPayerMny(totalActualPayerMny);
                for (PayerDetailEntity payerDetailEntity : payerEntity.getDetailList()) {
                    if (null == payerDetailEntity.getActualPayerMny()) continue;
                    payerDetailEntity.setActualPayerRatio(payerDetailEntity.getActualPayerMny().divide(totalActualPayerMny, 2, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
                }
                this.insertOrUpdate((PayerVO)BeanMapper.map((Object)((Object)payerEntity), PayerVO.class));
            }
        }
    }
}

