/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.standard.service.impl;

import com.ejianc.business.standard.bean.StandardRecordEntity;
import com.ejianc.business.standard.mapper.StandardRecordMapper;
import com.ejianc.business.standard.service.IStandardRecordService;
import com.ejianc.business.standard.vo.StandardRecordDetailVO;
import com.ejianc.business.standard.vo.StandardRecordVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="standardRecordService")
public class StandardRecordServiceImpl
extends BaseServiceImpl<StandardRecordMapper, StandardRecordEntity>
implements IStandardRecordService {
    @Override
    public StandardRecordVO transformWan(StandardRecordVO vo) {
        if (null != vo.getRiskDepositPayableMny()) {
            vo.setRiskDepositPayableMnyWan(vo.getRiskDepositPayableMny().divide(new BigDecimal(10000)));
        } else {
            vo.setRiskDepositPayableMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getRiskDepositMny()) {
            vo.setRiskDepositMnyWan(vo.getRiskDepositMny().divide(new BigDecimal(10000)));
        } else {
            vo.setRiskDepositMnyWan(BigDecimal.ZERO);
        }
        if ("directDept".equals(vo.getRiskDepositType())) {
            if (null != vo.getOutputMny()) {
                vo.setOutputMnyWan(vo.getOutputMny().divide(new BigDecimal(10000)));
            } else {
                vo.setOutputMnyWan(BigDecimal.ZERO);
            }
            if (null != vo.getLastYearContractMny()) {
                vo.setLastYearContractMnyWan(vo.getLastYearContractMny().divide(new BigDecimal(10000)));
            } else {
                vo.setLastYearContractMnyWan(BigDecimal.ZERO);
            }
            if (null != vo.getLastYearOutputMny()) {
                vo.setLastYearOutputMnyWan(vo.getLastYearOutputMny().divide(new BigDecimal(10000)));
            } else {
                vo.setLastYearOutputMnyWan(BigDecimal.ZERO);
            }
            if (null != vo.getWorkerCongressContractMny()) {
                vo.setWorkerCongressContractMnyWan(vo.getWorkerCongressContractMny().divide(new BigDecimal(10000)));
            } else {
                vo.setWorkerCongressContractMnyWan(BigDecimal.ZERO);
            }
        } else if (null != vo.getContractMny()) {
            vo.setContractMnyWan(vo.getContractMny().divide(new BigDecimal(10000)));
        } else {
            vo.setContractMnyWan(BigDecimal.ZERO);
        }
        List detailVOList = vo.getDetailList();
        for (StandardRecordDetailVO detail : detailVOList) {
            if (null != detail.getContractMny()) {
                detail.setContractMnyWan(detail.getContractMny().divide(new BigDecimal(10000)));
                continue;
            }
            detail.setContractMnyWan(BigDecimal.ZERO);
        }
        return vo;
    }
}

