package com.ejianc.business.payer.service.impl;

import com.ejianc.business.payer.vo.PayerRecordDetailVO;
import com.ejianc.business.payer.vo.PayerRecordVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.payer.mapper.PayerRecordMapper;
import com.ejianc.business.payer.bean.PayerRecordEntity;
import com.ejianc.business.payer.service.IPayerRecordService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 缴纳员工明细记录表主实体
 * 
 * @author generator
 * 
 */
@Service("payerRecordService")
public class PayerRecordServiceImpl extends BaseServiceImpl<PayerRecordMapper, PayerRecordEntity> implements IPayerRecordService {

    /**
     * 将缴纳员工明细的页面相关金额转换成万元
     * 直管部缴纳金额（万元）、员工应缴纳金额（万元）、缴纳金额（万元）、实际缴纳金额（万元）、未缴纳金额（万元）
     * @param vo
     * @return
     */
    @Override
    public PayerRecordVO transformWan(PayerRecordVO vo) {
        if (null != vo.getTotalPayerMny()){
            vo.setTotalPayerMnyWan(vo.getTotalPayerMny().divide(new BigDecimal(10000)));
        }else {
            vo.setTotalPayerMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getRiskDepositMny()){
            vo.setRiskDepositMnyWan(vo.getRiskDepositMny().divide(new BigDecimal(10000)));
        }else {
            vo.setRiskDepositMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getTotalActualPayerMny()){
            vo.setTotalActualPayerMnyWan(vo.getTotalActualPayerMny().divide(new BigDecimal(10000)));
        }else {
            vo.setTotalActualPayerMnyWan(BigDecimal.ZERO);
        }
        List<PayerRecordDetailVO> detailVOList = vo.getDetailList();
        for (PayerRecordDetailVO detail : detailVOList) {
            if (null != detail.getPayerMny()){
                detail.setPayerMnyWan(detail.getPayerMny().divide(new BigDecimal(10000)));
            }else {
                detail.setPayerMnyWan(BigDecimal.ZERO);
            }
            if (null != detail.getActualPayerMny()){
                detail.setActualPayerMnyWan(detail.getActualPayerMny().divide(new BigDecimal(10000)));
            }else {
                detail.setActualPayerMnyWan(BigDecimal.ZERO);
            }
            if (null != detail.getRemainderPayerMny()){
                detail.setRemainderPayerMnyWan(detail.getRemainderPayerMny().divide(new BigDecimal(10000)));
            }else {
                detail.setRemainderPayerMnyWan(BigDecimal.ZERO);
            }
        }
        return vo;
    }
}
