package com.ejianc.business.standard.service.impl;

import com.aliyun.teautil.Common;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.standard.bean.StandardDetailEntity;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.business.standard.vo.StandardDetailVO;
import com.ejianc.business.standard.vo.StandardVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.standard.mapper.StandardMapper;
import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.service.IStandardService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

/**
 * 风险金缴纳标准表主实体
 * 
 * @author generator
 * 
 */
@Service("standardService")
public class StandardServiceImpl extends BaseServiceImpl<StandardMapper, StandardEntity> implements IStandardService{
    private static final String DIRECT_BILL_CODE = "DIRECT_DEPT_PAYER";//直管部 风险金缴纳标准编码
    private static final String PROJECT_BILL_CODE = "PROJECT_DEPT_PAYER";//项目部 风险金缴纳标准编码


    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public Map<String, Object> countSumMny(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(risk_deposit_mny) as totalPayMny, sum(base_mny) as totalBasePayMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("totalPayMny", 0);
            resp.put("totalBasePayMny", 0);
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public StandardVO insertOrUpdate(StandardVO standardVO) {
        StandardEntity entity = BeanMapper.map(standardVO, StandardEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(("directDept").equals(standardVO.getRiskDepositType()) ? DIRECT_BILL_CODE : PROJECT_BILL_CODE, InvocationInfoProxy.getTenantid(),standardVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(!billCode.isSuccess()) {
                logger.error("保存标准表失败，自动生成标准表单据编码失败: {}", billCode.getMsg());
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillCode(billCode.getData());
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            entity.setBeforeChangeRiskDepositMny(standardVO.getRiskDepositMny());
            entity.setChangeVersion(0);
        }else {
            //如果切换标准表则把原来的缴纳人员都进行删除
            StandardEntity oldEntity = super.selectById(entity.getId());
            if (oldEntity != null && !oldEntity.getOrgId().equals(entity.getOrgId())){
                for (StandardDetailEntity oldDetail : oldEntity.getDetailList()) {
                    oldDetail.setRowState("del");
                }
                entity.getDetailList().addAll(oldEntity.getDetailList());
            }
        }
        entity.setBaseMny(standardVO.getRiskDepositMny());
        super.saveOrUpdate(entity, false);
        StandardVO returnVO = BeanMapper.map(super.selectById(entity.getId()), StandardVO.class);
        returnVO = transformWan(returnVO);
        return returnVO;
    }

    @Override
    public CommonResponse<String> queryProjectDeleteFlag(String projectIds) {
        List<String> ids = Arrays.asList(projectIds.split(","));
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, ids));

            List<StandardEntity> standardEntityList = super.queryList(queryParam);
            if (CollectionUtils.isNotEmpty(standardEntityList)) {
                String inUseProject = "";
                for (StandardEntity standardEntity : standardEntityList) {
                    inUseProject = inUseProject + standardEntity.getProjectName() + ",";
                }
                if (inUseProject.length() > 1) {
                    inUseProject = inUseProject.substring(0, inUseProject.length() - 1);
                }
                return CommonResponse.error("项目：" + inUseProject + "已被项目部标准表引用，不可删除！");
            }
        }
        return CommonResponse.success("项目未被项目部标准表引用，可以删除！");
    }

    @Override
    public StandardVO transformWan(StandardVO vo) {
        if (null != vo.getRiskDepositPayableMny()){
            vo.setRiskDepositPayableMnyWan(vo.getRiskDepositPayableMny().divide(new BigDecimal(10000)));
        }else {
            vo.setRiskDepositPayableMnyWan(BigDecimal.ZERO);
        }
        if (null != vo.getRiskDepositMny()){
            vo.setRiskDepositMnyWan(vo.getRiskDepositMny().divide(new BigDecimal(10000)));
        }else {
            vo.setRiskDepositMnyWan(BigDecimal.ZERO);
        }
        if ("directDept".equals(vo.getRiskDepositType())){

            if (null != vo.getOutputMny()){
                vo.setOutputMnyWan(vo.getOutputMny().divide(new BigDecimal(10000)));
            }else {
                vo.setOutputMnyWan(BigDecimal.ZERO);
            }

            if (null != vo.getLastYearContractMny()){
                vo.setLastYearContractMnyWan(vo.getLastYearContractMny().divide(new BigDecimal(10000)));
            }else {
                vo.setLastYearContractMnyWan(BigDecimal.ZERO);
            }
            if (null != vo.getLastYearOutputMny()){
                vo.setLastYearOutputMnyWan(vo.getLastYearOutputMny().divide(new BigDecimal(10000)));
            }else {
                vo.setLastYearOutputMnyWan(BigDecimal.ZERO);
            }
            if (null != vo.getWorkerCongressContractMny()){
                vo.setWorkerCongressContractMnyWan(vo.getWorkerCongressContractMny().divide(new BigDecimal(10000)));
            }else {
                vo.setWorkerCongressContractMnyWan(BigDecimal.ZERO);
            }

        }else {
            if (null != vo.getContractMny()){
                vo.setContractMnyWan(vo.getContractMny().divide(new BigDecimal(10000)));
            }else {
                vo.setContractMnyWan(BigDecimal.ZERO);
            }
        }
        List<StandardDetailVO> detailVOList = vo.getDetailList();
        for (StandardDetailVO detail : detailVOList) {
            if (null != detail.getContractMny()){
                detail.setContractMnyWan(detail.getContractMny().divide(new BigDecimal(10000)));
            }else {
                detail.setContractMnyWan(BigDecimal.ZERO);
            }
        }
        return vo;
    }
}
