package com.ejianc.business.rmat.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 设备明细
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@TableName("ejc_rmat_rent_settlement_detail")
public class RentSettlementDetailVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 结算表主键
     */
    private Long settlementId;

    /**
     * 物资ID
     */
    private Long materiaId;

    /**
     * 合同明细主键
     */
    private Long contractDetailId;
    /**
     * 物资分类名称
     */
    private String materialTypeName;
    /**
     * 物资分类ID
     */
    private String materialTypeId;
    /**
     * 物资分类编码
     */
    private String materialTypeCode;

    /**
     * 合同使用记录主键
     */
    private Long useId;

    /**
     * 合同使用记录子表主键
     */
    private Long useDetailId;

    /**
     * 使用记录编码
     */
    private String useCode;

    /**
     *
     */
    private Integer source;

    /**
     * 设备编码
     */
    private String code;

    /**
     * 设备名称
     */
    private String name;

    /**
     * 规格型号
     */
    private String spec;

    /**
     * 计量单位名称
     */
    private String unit;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 数量
     */
    private BigDecimal num;

    /**
     * 金额
     */
    private BigDecimal money;

    /**
     * 本期结算金额
     */
    private BigDecimal settlementMny;

    /**
     * 备注
     */
    private String memo;

    /**
     * 起租日期
     */
    private Date startDate;

    /**
     * 停租日期
     */
    private Date endDate;
    /**
     * 来源名称
     */
    private String sourceName;
    /**
     * 租期
     */
    private String rentTerm;
    /**
     * 成本科目主键
     */
    private Long subjectId;
    /**
     * 成本科目名称
     */
    private String subjectName;


    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getRentTerm() {
        return rentTerm;
    }

    public void setRentTerm(String rentTerm) {
        this.rentTerm = rentTerm;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }

    public Long getMateriaId() {
        return materiaId;
    }

    public void setMateriaId(Long materiaId) {
        this.materiaId = materiaId;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }
    public Long getUseId() {
        return useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }
    public Long getUseDetailId() {
        return useDetailId;
    }

    public void setUseDetailId(Long useDetailId) {
        this.useDetailId = useDetailId;
    }

    public String getUseCode() {
        return useCode;
    }

    public void setUseCode(String useCode) {
        this.useCode = useCode;
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(String materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }


}
