package com.ejianc.business.rmat.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 设备合同表
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
public class RentContractVO extends BaseVO {

    private static final long serialVersionUID = 2779265683222439571L;

    /**
     * 合同编码
     */
    private String billCode;
    private String billStateName;

    /**
     * 组织主键
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 项目主键
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 总包企业主键
     */
    private Long customerId;

    /**
     * 总包企业名称
     */
    private String customerName;

    /**
     * 设备供应商主键
     */
    private Long supplierId;

    /**
     * 设备供应商名称
     */
    private String supplierName;

    /**
     * 签约日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 合同税率
     */
    private BigDecimal taxRate;

    /**
     * 合同支付比例
     */
    private BigDecimal payScale;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    private String contractStatus;
    private String contractStatusName;
    private String supplierCreditCode;
    private String customerCreditCode;

    /**
     * 备注
     */
    private String memo;
    /**
     * 结算类型(0:过程结算，1:最终结算)
     */
    private Integer settlementType;

    /**
     * 合同金额(含税)
     */
    private BigDecimal contractTaxMny;

    /**
     * 合同金额(含税)
     */
    private BigDecimal showContractTaxMny;

    /**
     * 所属组织(采购组织)
     */
    private Long purchaseOrgId;

    /**
     * 所属组织名称(采购组织)
     */
    private String purchaseOrgName;

    private Integer replaceSignFlag; // 是否代签：0-否，1-是

    private java.lang.Long biddingTypeId; // 招标方式主键
    private java.lang.String biddingTypeName; // 招标方式名称
    private java.lang.Long announcementMediumId; // 公告媒介主键
    private java.lang.String announcementMediumName; // 公告媒介名称
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private java.util.Date bidOpeningTime; // 开标时间
    private java.math.BigDecimal acceptedAmount; // 中标金额
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private java.util.Date clintonTime; // 供赁时间


    public Integer getReplaceSignFlag() {
        return replaceSignFlag;
    }

    public void setReplaceSignFlag(Integer replaceSignFlag) {
        this.replaceSignFlag = replaceSignFlag;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getPurchaseOrgId() {
        return purchaseOrgId;
    }
    @ReferDeserialTransfer
    public void setPurchaseOrgId(Long purchaseOrgId) {
        this.purchaseOrgId = purchaseOrgId;
    }

    public String getPurchaseOrgName() {
        return purchaseOrgName;
    }

    public void setPurchaseOrgName(String purchaseOrgName) {
        this.purchaseOrgName = purchaseOrgName;
    }

    private Long mainContractId; // 主合同ID
    private String mainContractCode; // 主合同编码
    private String mainContractName; // 主合同名称
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private String isSupplement;

    private Long enquiryPriceBillId; // 定标单
    private String enquiryPriceBillName; // 定标单主题

    @ReferSerialTransfer(referCode="ejc-bidprice-material-result")
    public Long getEnquiryPriceBillId() {
        return enquiryPriceBillId;
    }

    @ReferDeserialTransfer
    public void setEnquiryPriceBillId(Long enquiryPriceBillId) {
        this.enquiryPriceBillId = enquiryPriceBillId;
    }

    public String getEnquiryPriceBillName() {
        return enquiryPriceBillName;
    }

    public void setEnquiryPriceBillName(String enquiryPriceBillName) {
        this.enquiryPriceBillName = enquiryPriceBillName;
    }

    public String getIsSupplement() {
		return isSupplement;
	}

	public void setIsSupplement(String isSupplement) {
		this.isSupplement = isSupplement;
	}

	public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public String getSupplierCreditCode() {
        return supplierCreditCode;
    }

    public void setSupplierCreditCode(String supplierCreditCode) {
        this.supplierCreditCode = supplierCreditCode;
    }

    public String getCustomerCreditCode() {
        return customerCreditCode;
    }

    public void setCustomerCreditCode(String customerCreditCode) {
        this.customerCreditCode = customerCreditCode;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public BigDecimal getShowContractTaxMny() {
        if (null != this.contractTaxMny) {
            return this.contractTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP);
        }
        return new BigDecimal(0).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    public Integer getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }

    /**
     * 税金
     */
    private BigDecimal taxMny;
    private BigDecimal showTaxMny;

    public BigDecimal getShowTaxMny() {
        if (null != this.taxMny) {
            return this.taxMny.setScale(2, BigDecimal.ROUND_HALF_UP);
        }
        return new BigDecimal(0).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 合同金额(不含税)
     */
    private BigDecimal contractMny;
    private BigDecimal showContractMny;

    public BigDecimal getShowContractMny() {
        if (null != this.contractMny) {
            return this.contractMny.setScale(2, BigDecimal.ROUND_HALF_UP);
        }
        return new BigDecimal(0).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;

    /**
     * 变更版本
     */
    private Integer changeVersion;

    /**
     * 变更主键
     */
    private Long changeId;

    /**
     * 变更编号
     */
    private String changeCode;

    /**
     * 初始版本金额（不含税）
     */
    private BigDecimal baseMoney;

    /**
     * 初始版本金额
     */
    private BigDecimal baseTaxMoney;

    /**
     * 变更前金额（不含税）
     */
    private BigDecimal beforeChangeMny;

    /**
     * 变更前金额
     */
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更中金额(不含税)
     */
    private BigDecimal changingMny;

    /**
     * 变更中金额
     */
    private BigDecimal changingTaxMny;

    /**
     * 变更状态1-未变更 2-变更中 3-已变更
     */
    private Integer changeStatus;
    private String changeStatusName;

    /**
     * 累计预付款金额
     */
    private BigDecimal sumPrepayMny;

    /**
     * 累计付款金额
     */
    private BigDecimal sumPayMny;

    /**
     * 累计冲抵金额
     */
    private BigDecimal sumOffsetMny;

    /**
     * 累计结算金额(不含税)
     */
    private BigDecimal sumSettlementMny;

    /**
     * 累计结算金额
     */
    private BigDecimal sumSettlementTaxMny;

    /**
     * 累计收票金额(不含税)
     */
    private BigDecimal sumInvoiceMny;

    /**
     * 累计收票金额
     */
    private BigDecimal sumInvoiceTaxMny;
    /**
     * 经办人名称
     */
    private String employeeName;
    /**
     * 合同名称
     */
    private String contractName;

    // 设备明细子表
    private List<RentContractDetailVO> rentdetail = new ArrayList<RentContractDetailVO>();

    // 合同条款子表
    private List<RentContractClauseVO> rentclause = new ArrayList<RentContractClauseVO>();

    // 其他费用子表
    private List<RentContractFeeVO> rentfee = new ArrayList<RentContractFeeVO>();

    // 周转材租赁合同付款阶段记录
    private List<RentContractStageVO> rentstage = new ArrayList<RentContractStageVO>();


    public String getContractStatusName() {
        return contractStatusName;
    }

    public void setContractStatusName(String contractStatusName) {
        this.contractStatusName = contractStatusName;
    }

    public String getChangeStatusName() {
        return changeStatusName;
    }

    public List<RentContractStageVO> getRentstage() {
        return rentstage;
    }

    public void setRentstage(List<RentContractStageVO> rentstage) {
        this.rentstage = rentstage;
    }

    public void setChangeStatusName(String changeStatusName) {
        this.changeStatusName = changeStatusName;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getBillCode() {
        return billCode;
    }


    public List<RentContractDetailVO> getRentdetail() {
        return rentdetail;
    }

    public void setRentdetail(List<RentContractDetailVO> rentdetail) {
        this.rentdetail = rentdetail;
    }

    public List<RentContractClauseVO> getRentclause() {
        return rentclause;
    }

    public void setRentclause(List<RentContractClauseVO> rentclause) {
        this.rentclause = rentclause;
    }

    public List<RentContractFeeVO> getRentfee() {
        return rentfee;
    }

    public void setRentfee(List<RentContractFeeVO> rentfee) {
        this.rentfee = rentfee;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    public void setShowContractTaxMny(BigDecimal showContractTaxMny) {
        this.showContractTaxMny = showContractTaxMny;
    }

    public void setShowTaxMny(BigDecimal showTaxMny) {
        this.showTaxMny = showTaxMny;
    }

    public void setShowContractMny(BigDecimal showContractMny) {
        this.showContractMny = showContractMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    public void setSumPrepayMny(BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumOffsetMny() {
        return sumOffsetMny;
    }

    public void setSumOffsetMny(BigDecimal sumOffsetMny) {
        this.sumOffsetMny = sumOffsetMny;
    }

    public BigDecimal getSumSettlementMny() {
        return sumSettlementMny;
    }

    public void setSumSettlementMny(BigDecimal sumSettlementMny) {
        this.sumSettlementMny = sumSettlementMny;
    }

    public BigDecimal getSumSettlementTaxMny() {
        return sumSettlementTaxMny;
    }

    public void setSumSettlementTaxMny(BigDecimal sumSettlementTaxMny) {
        this.sumSettlementTaxMny = sumSettlementTaxMny;
    }

    public BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    public void setSumInvoiceMny(BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }

    public BigDecimal getSumInvoiceTaxMny() {
        return sumInvoiceTaxMny;
    }

    public void setSumInvoiceTaxMny(BigDecimal sumInvoiceTaxMny) {
        this.sumInvoiceTaxMny = sumInvoiceTaxMny;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    @ReferSerialTransfer(referCode = "support-customer")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getBiddingTypeId() {
        return biddingTypeId;
    }
    @ReferDeserialTransfer
    public void setBiddingTypeId(Long biddingTypeId) {
        this.biddingTypeId = biddingTypeId;
    }

    public String getBiddingTypeName() {
        return biddingTypeName;
    }

    public void setBiddingTypeName(String biddingTypeName) {
        this.biddingTypeName = biddingTypeName;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getAnnouncementMediumId() {
        return announcementMediumId;
    }
    @ReferDeserialTransfer
    public void setAnnouncementMediumId(Long announcementMediumId) {
        this.announcementMediumId = announcementMediumId;
    }

    public String getAnnouncementMediumName() {
        return announcementMediumName;
    }

    public void setAnnouncementMediumName(String announcementMediumName) {
        this.announcementMediumName = announcementMediumName;
    }

    public Date getBidOpeningTime() {
        return bidOpeningTime;
    }

    public void setBidOpeningTime(Date bidOpeningTime) {
        this.bidOpeningTime = bidOpeningTime;
    }

    public BigDecimal getAcceptedAmount() {
        return acceptedAmount;
    }

    public void setAcceptedAmount(BigDecimal acceptedAmount) {
        this.acceptedAmount = acceptedAmount;
    }

    public Date getClintonTime() {
        return clintonTime;
    }

    public void setClintonTime(Date clintonTime) {
        this.clintonTime = clintonTime;
    }
}
