package com.ejianc.business.rmat.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rmat.hystrix.RmatContractHystrix;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.business.rmat.vo.RmatProjectReportVo;
import com.ejianc.business.rmat.vo.RmatSettlementVO;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * 获取合同参照工厂类方法
 *
 * @author yqls
 */
@FeignClient(name = "ejc-rmat-web", url = "${common.env.feign-client-url}", path = "ejc-rmat-web", fallback = RmatContractHystrix.class)
public interface IRmatContractApi {

    /**
     * @Author sunyj
     * @Date 2020/7/4
     * @Description 收票审批通过后更新周转材租赁合同合同开票金额等字段
     * @Param contractId  合同id
     * @Param invoiceMny、invoiceTaxMny  收票金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @PostMapping(value = "/api/rmat/rentAfterApproveInvoiceReceive")
    CommonResponse<String> rentAfterApproveInvoiceReceive(@RequestParam(value = "contractId", required = true) Long contractId,
                                                          @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny);

    /**
     * @Author sunyj
     * @Date 2020/7/4
     * @Description 收票弃审通过后更新周转材租赁合同开票金额等字段
     * @Param contractId  合同id
     * @Param invoiceMny、invoiceTaxMny  收票金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @PostMapping(value = "/api/rmat/rentAfterRevocationInvoiceReceive")
    CommonResponse<JSONObject> rentAfterRevocationInvoiceReceive(@RequestParam(value = "contractId", required = true) Long contractId,
                                                                 @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny);


    /**
     * 根据条件查询不同合同类型的合同
     *
     * @return
     */
    @GetMapping(value = "/api/rmat/getRentContractById")
    public CommonResponse<ContractResVO> getContractById(@RequestParam(value = "contractId", required = true) Long contractId);

    /**
     * 根据条件查询不同合同类型的合同结算
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "/api/rmat/getRmatSettle")
    public CommonResponse<JSONObject> getRmatSettle(@RequestBody QueryParam queryParam);

    /**
     * 回写周转材租赁结算单累计付款金额
     *
     * @param settleId 结算单id
     * @param payMny   本期支付金额，正为回写，负为逆回写
     * @return
     */
    @GetMapping(value = "/api/rmat/updateRentSettleSumPayMny")
    CommonResponse<String> updateRentSettleSumPayMny(@RequestParam(value = "settleId", required = true) Long settleId,
                                                     @RequestParam("payMny") BigDecimal payMny);


    /**
     * 回写周转材租赁结算单累计申请金额、剩余可申请金额
     *
     * @param settleId 结算单id
     * @param applyMny 本期申请金额，正为回写，负为逆回写
     * @return
     */
    @GetMapping(value = "/api/rmat/updateRentSettleSumApplyMny")
    CommonResponse<String> updateRentSettleSumApplyMny(@RequestParam(value = "settleId", required = true) Long settleId,
                                                       @RequestParam("applyMny") BigDecimal applyMny);


    /**
     * 回写周转材租赁合同累计付款金额、累计预付款金额
     *
     * @param contractId
     * @param payMny     本期支付金额，正为回写，负为逆回写
     * @param prepayMny  本期预付款金额，正为回写，负为逆回写
     * @return
     */
    @GetMapping(value = "/api/rmat/updateRentContractSumPayMny")
    CommonResponse<String> updateRentContractSumPayMny(@RequestParam(value = "contractId", required = true) Long contractId,
                                                       @RequestParam("payMny") BigDecimal payMny, @RequestParam("prepayMny") BigDecimal prepayMny);


    /**
     * /**
     * 根据条件查询结算单累计冲抵金额
     *
     * @return
     */
    @GetMapping(value = "/api/rmat/getRentSettlementById")
    public CommonResponse<RmatSettlementVO> getRentSettlementById(@RequestParam(value = "contractId", required = true) Long contractId, @RequestParam(value = "orgId", required = true) Long orgId);

    /**
     * 查周转材合同结算
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    @RequestMapping(value = "/api/rmat/getMonthRmatMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RmatProjectReportVo>> getMonthRmatMny(@RequestParam(value = "projectId") Long projectId,
                                                                      @RequestParam(value = "lastDay") Integer lastDay);

    /**
     * 查周转材合同数量，金额，结算金额
     *
     * @param projectId
     *
     * @return
     */
    @GetMapping(value = "/api/rmat/getRmatContract")
    @ResponseBody
    public CommonResponse<RmatProjectReportVo> getRmatContract(@RequestParam(value = "projectId") Long projectId);

    /**
     * 按项目维度，获取合同金额(含税)
     *
     * @param projectId 项目id
     *
     * @return {@link CommonResponse}<{@link BigDecimal}>
     */
    @GetMapping(value = "/api/rmat/fetchContractTaxMny")
    CommonResponse<BigDecimal> fetchContractTaxMny(@RequestParam(value = "projectId") Long projectId);

    /**
     * 查周转材合同数量，金额，结算金额
     *
     * @param projectIds
     *
     * @return
     */
    @PostMapping(value = "/api/rmat/getContractMnyByProjectIds")
    @ResponseBody
    CommonResponse<RmatProjectReportVo> getContractMnyByProjectIds(@RequestBody List<Long> projectIds);


    @PostMapping(value = "/api/rmat/getContractByCondition")
    @ResponseBody
    CommonResponse<List<RentContractVO>> getContractByCondition(@RequestBody List<Long> enquiryPriceBillIds);

    @GetMapping(value = "/api/rmat/fetchSjzcje")
    CommonResponse<BigDecimal> fetchSjzcje(@RequestParam(value = "projectId") Long projectId);
}
