/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rmat.hystrix.RmatContractHystrix;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.business.rmat.vo.RmatProjectReportVo;
import com.ejianc.business.rmat.vo.RmatSettlementVO;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@FeignClient(name="ejc-rmat-web", url="${common.env.feign-client-url}", path="ejc-rmat-web", fallback=RmatContractHystrix.class)
public interface IRmatContractApi {
    @PostMapping(value={"/api/rmat/rentAfterApproveInvoiceReceive"})
    public CommonResponse<String> rentAfterApproveInvoiceReceive(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="invoiceMny") BigDecimal var2, @RequestParam(value="invoiceTaxMny") BigDecimal var3);

    @PostMapping(value={"/api/rmat/rentAfterRevocationInvoiceReceive"})
    public CommonResponse<JSONObject> rentAfterRevocationInvoiceReceive(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="invoiceMny") BigDecimal var2, @RequestParam(value="invoiceTaxMny") BigDecimal var3);

    @GetMapping(value={"/api/rmat/getRentContractById"})
    public CommonResponse<ContractResVO> getContractById(@RequestParam(value="contractId", required=true) Long var1);

    @PostMapping(value={"/api/rmat/getRmatSettle"})
    public CommonResponse<JSONObject> getRmatSettle(@RequestBody QueryParam var1);

    @GetMapping(value={"/api/rmat/updateRentSettleSumPayMny"})
    public CommonResponse<String> updateRentSettleSumPayMny(@RequestParam(value="settleId", required=true) Long var1, @RequestParam(value="payMny") BigDecimal var2);

    @GetMapping(value={"/api/rmat/updateRentSettleSumApplyMny"})
    public CommonResponse<String> updateRentSettleSumApplyMny(@RequestParam(value="settleId", required=true) Long var1, @RequestParam(value="applyMny") BigDecimal var2);

    @GetMapping(value={"/api/rmat/updateRentContractSumPayMny"})
    public CommonResponse<String> updateRentContractSumPayMny(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="payMny") BigDecimal var2, @RequestParam(value="prepayMny") BigDecimal var3);

    @GetMapping(value={"/api/rmat/getRentSettlementById"})
    public CommonResponse<RmatSettlementVO> getRentSettlementById(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="orgId", required=true) Long var2);

    @RequestMapping(value={"/api/rmat/getMonthRmatMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<RmatProjectReportVo>> getMonthRmatMny(@RequestParam(value="projectId") Long var1, @RequestParam(value="lastDay") Integer var2);

    @GetMapping(value={"/api/rmat/getRmatContract"})
    @ResponseBody
    public CommonResponse<RmatProjectReportVo> getRmatContract(@RequestParam(value="projectId") Long var1);

    @GetMapping(value={"/api/rmat/fetchContractTaxMny"})
    public CommonResponse<BigDecimal> fetchContractTaxMny(@RequestParam(value="projectId") Long var1);

    @PostMapping(value={"/api/rmat/getContractMnyByProjectIds"})
    @ResponseBody
    public CommonResponse<RmatProjectReportVo> getContractMnyByProjectIds(@RequestBody List<Long> var1);

    @PostMapping(value={"/api/rmat/getContractByCondition"})
    @ResponseBody
    public CommonResponse<List<RentContractVO>> getContractByCondition(@RequestBody List<Long> var1);

    @GetMapping(value={"/api/rmat/fetchSjzcje"})
    public CommonResponse<BigDecimal> fetchSjzcje(@RequestParam(value="projectId") Long var1);
}

