package com.ejianc.business.rmat.hystrix;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.business.rmat.vo.RmatProjectReportVo;
import com.ejianc.business.rmat.vo.RmatSettlementVO;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * 模块hystrix
 *
 * @author guoming
 */
@Component
public class RmatContractHystrix implements IRmatContractApi {


    /**
     * @param contractId
     * @param invoiceMny
     * @param invoiceTaxMny
     * @Author sunyj
     * @Date 2020/7/4
     * @Description 收票审批通过后更新周转材租赁合同合同开票金额等字段
     * @Param contractId  合同id
     * @Param invoiceMny、invoiceTaxMny  收票金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @Override
    public CommonResponse<String> rentAfterApproveInvoiceReceive(Long contractId, BigDecimal invoiceMny, BigDecimal invoiceTaxMny) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    /**
     * @param contractId
     * @param invoiceMny
     * @param invoiceTaxMny
     * @Author sunyj
     * @Date 2020/7/4
     * @Description 收票弃审通过后更新周转材租赁合同开票金额等字段
     * @Param contractId  合同id
     * @Param invoiceMny、invoiceTaxMny  收票金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @Override
    public CommonResponse<JSONObject> rentAfterRevocationInvoiceReceive(Long contractId, BigDecimal invoiceMny, BigDecimal invoiceTaxMny) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    /**
     * 根据条件查询不同合同类型的合同
     *
     * @param contractId
     * @return
     */
    @Override
    public CommonResponse<ContractResVO> getContractById(Long contractId) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    @Override
    public CommonResponse<JSONObject> getRmatSettle(QueryParam queryParam) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    /**
     * 回写周转材租赁结算单累计付款金额
     *
     * @param settleId 结算单id
     * @param payMny   本期支付金额，正为回写，负为逆回写
     * @return
     */
    @Override
    public CommonResponse<String> updateRentSettleSumPayMny(Long settleId, BigDecimal payMny) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    /**
     * 回写周转材租赁结算单累计申请金额、剩余可申请金额
     *
     * @param settleId 结算单id
     * @param applyMny 本期申请金额，正为回写，负为逆回写
     * @return
     */
    @Override
    public CommonResponse<String> updateRentSettleSumApplyMny(Long settleId, BigDecimal applyMny) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    /**
     * 回写周转材租赁合同累计付款金额、累计预付款金额
     *
     * @param contractId
     * @param payMny     本期支付金额，正为回写，负为逆回写
     * @param prepayMny  本期预付款金额，正为回写，负为逆回写
     * @return
     */
    @Override
    public CommonResponse<String> updateRentContractSumPayMny(Long contractId, BigDecimal payMny, BigDecimal prepayMny) {
        return CommonResponse.error("网络问题， 查询失败。");
    }


    @Override
    public CommonResponse<RmatSettlementVO> getRentSettlementById(Long contractId, Long orgId) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    /**
     * 查周转材合同结算
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    @Override
    public CommonResponse<List<RmatProjectReportVo>> getMonthRmatMny(Long projectId, Integer lastDay) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    /**
     * 查周转材合同数量，金额，结算金额
     *
     * @param projectId
     * @return
     */
    @Override
    public CommonResponse<RmatProjectReportVo> getRmatContract(Long projectId) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    /**
     * 按项目维度，获取合同金额(含税)
     *
     * @param projectId 项目id
     *
     * @return {@link CommonResponse}<{@link BigDecimal}>
     */
    @Override
    public CommonResponse<BigDecimal> fetchContractTaxMny(Long projectId) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    @Override
    public CommonResponse<RmatProjectReportVo> getContractMnyByProjectIds(List<Long> projectIds) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    @Override
    public CommonResponse<List<RentContractVO>> getContractByCondition(List<Long> enquiryPriceBillIds) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    @Override
    public CommonResponse<BigDecimal> fetchSjzcje(Long projectId) {
        return CommonResponse.error("网络问题， 查询失败。");
    }
}
