package com.ejianc.business.rmat.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * <p>
 * 其他费用
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@TableName("ejc_rmat_rent_settlement_fee")
public class RentSettlementFeeVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 结算主键
     */
    private Long settlementId;

    /**
     * 费用类型
     */
    private String feeType;

    /**
     * 金额
     */
    private BigDecimal feemoney;

    /**
     * 备注
     */
    private String memo;
    /**
     * 使用记录主表主键
     */
    private Long useId;
    /**
     * 来源
     */
    private String source;
    /**
     * 成本科目主键
     */
    private Long subjectId;
    /**
     * 成本科目名称
     */
    private String subjectName;
    /**
     * 成本科目集团主键
     */
    private Long orgSubjectId;
    /**
     * 核算对象主键
     */
    private Long accountingId;

    /**
     * 核算对象名称
     */
    private String accountingName;

    /**
     * 核算对象集团主键
     */
    private Long orgAccountingId;


    private BigDecimal freeTaxRate;//税率
    private BigDecimal taxMoney;//含税金额

    public BigDecimal getFreeTaxRate() {
        return freeTaxRate;
    }

    public void setFreeTaxRate(BigDecimal freeTaxRate) {
        this.freeTaxRate = freeTaxRate;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public Long getUseId() {
        return useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public BigDecimal getFeemoney() {
        return feemoney;
    }

    public void setFeemoney(BigDecimal feemoney) {
        this.feemoney = feemoney;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode = "cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }

    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getOrgSubjectId() {
        return orgSubjectId;
    }

    public void setOrgSubjectId(Long orgSubjectId) {
        this.orgSubjectId = orgSubjectId;
    }

    @ReferSerialTransfer(referCode="accounting-project-ref")
    public Long getAccountingId() {
        return accountingId;
    }

    @ReferDeserialTransfer
    public void setAccountingId(Long accountingId) {
        this.accountingId = accountingId;
    }

    public String getAccountingName() {
        return accountingName;
    }

    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }

    public Long getOrgAccountingId() {
        return orgAccountingId;
    }

    public void setOrgAccountingId(Long orgAccountingId) {
        this.orgAccountingId = orgAccountingId;
    }
}
