package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rmat.bean.RentChangeEntity;
import com.ejianc.business.rmat.bean.RentContractDetailEntity;
import com.ejianc.business.rmat.bean.RentContractEntity;
import com.ejianc.business.rmat.bean.RentSettlementEntity;
import com.ejianc.business.rmat.controller.SqlParam;
import com.ejianc.business.rmat.mapper.RentContractMapper;
import com.ejianc.business.rmat.service.*;
import com.ejianc.business.rmat.vo.RentContractDetailVO;
import com.ejianc.business.rmat.vo.RentContractVO;
import com.ejianc.business.rmat.vo.RmatProjectReportVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 设备合同表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
@Service("RentContractService")
public class RentContractServiceImpl extends BaseServiceImpl<RentContractMapper, RentContractEntity> implements IRentContractService {

    private static final String RENT_CONTRACT_BILL_CODE = "RMAT_CONTRACT";

    @Autowired
    private IRentChangeService rentChangeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private CommonBillCodeService commonBillCodeService;

    @Autowired
    private IRentSettlementService settlementService;

    @Override
    public CommonResponse<RentContractVO> saveOrUpdate(RentContractVO rentContractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentContractEntity entity = BeanMapper.map(rentContractVo, RentContractEntity.class);
        String operateType = null;
        List<RentContractEntity> entities = null;
        List<RentChangeEntity> entitiesc = null;
        if (StringUtils.isEmpty(rentContractVo.getBillCode())) {
            String code = commonBillCodeService.getCodeByOrgId(rentContractVo.getOrgId(), RENT_CONTRACT_BILL_CODE, rentContractVo);
            entity.setBillCode(code);
        }
        if (rentContractVo.getId() != null && rentContractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getSupplementFlag, 0);
            lambda.eq(RentContractEntity::getBillCode, rentContractVo.getBillCode());
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.ne(RentContractEntity::getId, rentContractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, rentContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, rentContractVo.getId()));
            entitiesc = rentChangeService.queryList(queryParam, false);
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.eq(RentContractEntity::getSupplementFlag, 0);
            lambda.eq(RentContractEntity::getBillCode, rentContractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, rentContractVo.getBillCode()));
            entitiesc = rentChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        if (CollectionUtils.isNotEmpty(entities) || CollectionUtils.isNotEmpty(entitiesc)) {
            return CommonResponse.error("存在相同编码，不允许保存!");
        }
        entity.setBaseMoney(rentContractVo.getContractMny() == null ? BigDecimal.ZERO : rentContractVo.getContractMny());
        entity.setBaseTaxMoney(rentContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(rentContractVo.getContractMny() == null ? BigDecimal.ZERO : rentContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(rentContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVo.getContractTaxMny());
        super.saveOrUpdate(entity, false);

        return CommonResponse.success(BeanMapper.map(entity, RentContractVO.class));
    }

    @Override
    public RentContractVO queryDetail(Long id) {
        RentContractEntity entity = super.selectById(id);
        entity.setRentdetail(null);
        RentContractVO rentContractVo = BeanMapper.map(entity, RentContractVO.class);
        List<RentContractDetailEntity> details = null;
        LambdaQueryWrapper<RentContractDetailEntity> lambda = Wrappers.<RentContractDetailEntity>lambdaQuery();
        lambda.eq(RentContractDetailEntity::getContractId, id);
        lambda.apply("ISNULL(change_type) <> 3");
        details = rentContractDetailService.list(lambda);
        if (CollectionUtils.isNotEmpty(details)) {
            rentContractVo.setRentdetail(BeanMapper.mapList(details, RentContractDetailVO.class));
        }
        return rentContractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount");
        resp = super.getMap(wrapper);
//
        return resp;
    }

    @Override
    public void deleteRentContract(List<RentContractVO> vos) {
        super.removeByIds(vos.stream().map(RentContractVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.querySettleWarnContract(sqlParamList);
    }
    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPayWarnContract(sqlParamList);
    }
    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPrePayWarnContract(sqlParamList);
    }
    @Override
    public List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryTaxWarnContract(sqlParamList);
    }

    @Override
    public List<RmatProjectReportVo> getMonthRmatMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthRmatMny(projectId, lastDay);
    }

    @Override
    public RmatProjectReportVo getRmatContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal settleMny = BigDecimal.ZERO;
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<RentContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RentContractEntity::getProjectId, projectId);
        wrapper.eq(RentContractEntity::getDr, 0);
        wrapper.in(RentContractEntity::getBillState, billStatus);
        List<RentContractEntity> contractEntityList = super.list(wrapper);
        for (RentContractEntity entity : contractEntityList) {
            mny = mny.add(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        }
        LambdaQueryWrapper<RentSettlementEntity> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(RentSettlementEntity::getProjectId, projectId);
        wrapper2.eq(RentSettlementEntity::getDr, 0);
        wrapper2.in(RentSettlementEntity::getBillState, billStatus);
        List<RentSettlementEntity> settlementEntityList = settlementService.list(wrapper2);
        for (RentSettlementEntity entity : settlementEntityList) {
            settleMny = settleMny.add(entity.getSettlementTaxMny() == null ? BigDecimal.ZERO : entity.getSettlementTaxMny());
        }
        RmatProjectReportVo vo = new RmatProjectReportVo();
        vo.setMny(mny);
        vo.setNum(contractEntityList.size());
        vo.setSettleMny(settleMny);

        return vo;
    }

}
