package com.ejianc.business.rmat.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.rmat.bean.ApplyDetailEntity;
import com.ejianc.business.rmat.service.IApplyDetailService;
import com.ejianc.business.rmat.vo.ApplyDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 设备使用申请明细 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-06
 */
@RestController
@RequestMapping("applyDetail")
public class ApplyDetailController {
    @Autowired
    private IApplyDetailService applyDetailService;
    @Autowired
    private IOrgApi orgApi;

    /**
     * 设备使用申请列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @GetMapping("/applyDetailRef")
    public CommonResponse<IPage<ApplyDetailVO>> applyDetailRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                 @RequestParam(defaultValue = "10") Integer pageSize,
                                                                 @RequestParam(value = "relyCondition", required = false) String relyCondition,
                                                                 @RequestParam(value = "searchText", required = false) String searchText) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        if(StringUtils.isNotBlank(relyCondition)){
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            queryParam.getParams().put("applyId", new Parameter(QueryParam.EQ, categoryId));

        }
        IPage<ApplyDetailEntity> pageData = applyDetailService.queryPage(queryParam,false);
        IPage<ApplyDetailVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), ApplyDetailVO.class));
        return CommonResponse.success("设备使用申请详情查询成功！", result);
    }
}
