package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.rmat.service.IPurchaseContractService;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.pub.vo.PubWarnQueryVO;
import com.ejianc.business.finance.vo.PayMnyWarnVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceMnyWarnVO;
import com.ejianc.business.tax.vo.InvoicePubWarnQueryVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author sunyj
 * @Description:
 * @date 2021/3/9
 */
@RestController
@RequestMapping(value = "/purchaseContractWarn/")
public class PurchaseContractWarnController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PC_URL = "/ejc-equipment-frontend/#/purchaseContract/purchaseContractApprove?id=";

    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private ITenantApi tenantApi;

    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IPayContractApi payContractApi;

    @Autowired
    private IInvoiceApi invoiceApi;
    @PostMapping(value = "settleWarnExecute")
    public CommonResponse<String> settleWarnExecute(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);


        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if(!tenantResp.isSuccess()) {
            logger.error("执行设备采购合同【结算金额】大于【合同金额】预警失败，获取有效的租户Id列表失败：{}", tenantResp.getMsg());
            return CommonResponse.error("执行设备采购合同预警失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if(CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行设备采购合同【结算金额】大于【合同金额】预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //去掉停用的预警对应的租户Id
        tenantIds.removeAll(ignoreTenantIds);
        if(CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行设备采购合同【结算金额】大于【合同金额】预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<SqlParam> sqlParamList = new ArrayList<>();
        JSONObject warnInfo = null;
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
        for(JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }

        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);
        List<SqlParam> defaultParam = null;

        for(Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
        }

        List<Map<String, Object>> result = purchaseContractService.querySettleWarnContract(sqlParamList);
        if(CollectionUtils.isEmpty(result)) {
            logger.error("执行设备采购合同【结算金额】大于【合同金额】预警完成，未发现有匹配预警规则的合同信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        return sendWarnToTask(transToWarnVO(result, defaultWarnInfo,0), defaultWarnInfo.getLong("warnSetId"));
    }
    @PostMapping(value = "payWarnExecute")
    public CommonResponse<String> payWarnExecute(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);


        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if(!tenantResp.isSuccess()) {
            logger.error("执行设备采购合同【付款金额】大于【合同金额】预警失败，获取有效的租户Id列表失败：{}", tenantResp.getMsg());
            return CommonResponse.error("执行设备采购合同预警失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if(CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行设备采购合同【付款金额】大于【合同金额】预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //去掉停用的预警对应的租户Id
        tenantIds.removeAll(ignoreTenantIds);
        if(CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行设备采购合同【付款金额】大于【合同金额】预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<SqlParam> sqlParamList = new ArrayList<>();
        JSONObject warnInfo = null;
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
        for(JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }

        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);
        List<SqlParam> defaultParam = null;

        for(Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
        }

        List<Map<String, Object>> result = purchaseContractService.queryPayWarnContract(sqlParamList);
        if(CollectionUtils.isEmpty(result)) {
            logger.error("执行设备采购合同【付款金额】大于【合同金额】预警完成，未发现有匹配预警规则的合同信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        return sendWarnToTask(transToWarnVO(result, defaultWarnInfo,0), defaultWarnInfo.getLong("warnSetId"));
    }
    @PostMapping(value = "prePayWarnExecute")
    public CommonResponse<String> prePayWarnExecute(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);


        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if(!tenantResp.isSuccess()) {
            logger.error("执行设备采购合同【预付款金额】大于【合同金额】预警失败，获取有效的租户Id列表失败：{}", tenantResp.getMsg());
            return CommonResponse.error("执行设备采购合同预警失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if(CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行设备采购合同【预付款金额】大于【合同金额】预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //去掉停用的预警对应的租户Id
        tenantIds.removeAll(ignoreTenantIds);
        if(CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行设备采购合同【预付款金额】大于【合同金额】预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<SqlParam> sqlParamList = new ArrayList<>();
        JSONObject warnInfo = null;
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
        for(JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }

        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);
        List<SqlParam> defaultParam = null;

        for(Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
        }

        List<Map<String, Object>> result = purchaseContractService.queryPrePayWarnContract(sqlParamList);
        if(CollectionUtils.isEmpty(result)) {
            logger.error("执行设备采购合同【预付款金额】大于【合同金额】预警完成，未发现有匹配预警规则的合同信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        return sendWarnToTask(transToWarnVO(result, defaultWarnInfo,0), defaultWarnInfo.getLong("warnSetId"));
    }
    @PostMapping(value = "invoicePayMnyWarn")
    public CommonResponse<String> invoicePayMnyWarn(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));

        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if(!tenantResp.isSuccess()) {
            return CommonResponse.error("执行设备采购合同收票金额小于付款金额预警失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if(CollectionUtils.isEmpty(tenantIds)) {
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //1.去掉停用的预警对应的租户Id（不用任何处理）
        tenantIds.removeAll(ignoreTenantIds);
        if(CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行设备采购合同收票金额小于付款金额预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        //2.再去掉自定义租户ID，走自定义的预警条件
        List<SqlParam> sqlParamList = new ArrayList<>();
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
        for(JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }

        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);

        //3.除了忽略和自定义，其他都走默认预警条件
        for(Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
        }

        //1.自采类型，直接取合同上的付款金额和收票金额判断
        List<Map<String, Object>> result = purchaseContractService.invoicePayMnyWarn(sqlParamList);
        List<EarlyWarnTransVO> warnTransVOS = new ArrayList<>();
        if(!CollectionUtils.isEmpty(result)) {
            warnTransVOS.addAll(transToWarnVO(result, defaultWarnInfo,1));
        }

        //2.集采类型，从付款和收票上取
        Map<Long, SqlParam> paramMap = new HashMap<>();
        List<Long> tenantidList = new ArrayList<>();
        for (SqlParam param : sqlParamList) {
            paramMap.put(param.getTenantId(), param);
            tenantidList.add(param.getTenantId());
        }

        PubWarnQueryVO pubWarnQueryVO = new PubWarnQueryVO();
        pubWarnQueryVO.setContractType(2);
        pubWarnQueryVO.setTenantIds(tenantidList);
        CommonResponse<Map<String, PayMnyWarnVO>> payResponse = payContractApi.getPayMnyByTenantIds(pubWarnQueryVO);
        if(payResponse.isSuccess() && !payResponse.getData().isEmpty()){
            Map<String, PayMnyWarnVO> payMap = payResponse.getData();
            InvoicePubWarnQueryVO invoicePubWarnQueryVO = new InvoicePubWarnQueryVO();
            invoicePubWarnQueryVO.setContractType(2);
            invoicePubWarnQueryVO.setTenantIds(tenantidList);
            CommonResponse<Map<String, InvoiceMnyWarnVO>> invoiceResponse = invoiceApi.getInvoiceMnyByTenantIds(invoicePubWarnQueryVO);
            Map<String, InvoiceMnyWarnVO> invoiceMap = invoiceResponse.getData();
            for(String key : payMap.keySet()){
                PayMnyWarnVO payWarnVO = payMap.get(key);
                SqlParam param = paramMap.get(payWarnVO.getTenantId());
                BigDecimal invoiceMny = BigDecimal.ZERO;
                if(null != invoiceMap && invoiceMap.containsKey(key)){
                    invoiceMny = invoiceMap.get(key).getSumInvoiceMny();
                }
                BigDecimal overMny = payWarnVO.getSumPayMny().multiply(new BigDecimal(param.getValue())).subtract(invoiceMny);
                if(overMny.compareTo(BigDecimal.ZERO) >= 0){
                    warnTransVOS.add(margeInvoicePayToWarnVO(payWarnVO, invoiceMny, overMny, param, defaultWarnInfo));
                }
            }
        }
        return sendWarnToTask(warnTransVOS, defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo,Integer type) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for(Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + m.get("contractCode").toString());
            vo.setPcTitle("设备采购合同");
            vo.setPcUrl(PC_URL + m.get("contractId").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("contractId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            if (type == 0){
                vo.setEarlywarnContent(
                        tmpContent.replaceAll("#contractName#", m.get("contractName").toString())
                                .replaceAll("#contractSettlementAmt#", df.format(new BigDecimal(m.get("contractSettlementAmt").toString())))
                                .replaceAll("#contractAmt#", df.format(new BigDecimal(m.get("contractAmt").toString())))
                                .replaceAll("#percent#", m.get("percent").toString())
                                .replaceAll("#overAmt#", df.format(new BigDecimal(m.get("overAmt").toString())))
                );
            }
            if (type == 1){
                vo.setEarlywarnContent(
                        tmpContent.replaceAll("#orgName#", m.get("orgName").toString())
                                .replaceAll("#contractName#", m.get("contractName").toString())
                                .replaceAll("#sumInvoiceTaxMny#", df.format(getBigDecimal(m.get("sumInvoiceTaxMny"))))
                                .replaceAll("#sumPayMny#", df.format(getBigDecimal(m.get("sumPayMny"))))
                                .replaceAll("#percent#", m.get("percent").toString())
                                .replaceAll("#overMny#", df.format(getBigDecimal(m.get("overMny"))))
                );
            }


            resp.add(vo);
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }
    private EarlyWarnTransVO margeInvoicePayToWarnVO(PayMnyWarnVO payWarnVO, BigDecimal invoiceMny, BigDecimal overMny, SqlParam param, JSONObject defaultWarnInfo) {
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + payWarnVO.getContractCode());
        vo.setPcTitle("设备采购合同");
        vo.setPcUrl(PC_URL + payWarnVO.getContractId().toString());
        vo.setOrgId(payWarnVO.getOrgId());
        vo.setOrgName(payWarnVO.getOrgName());
        vo.setSourceId(payWarnVO.getContractId().toString());
        vo.setTenantId(payWarnVO.getTenantId());
        vo.setWarnLevel(param.getWarnLevel());
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(
                tmpContent.replaceAll("#orgName#", payWarnVO.getOrgName())
                        .replaceAll("#contractName#", payWarnVO.getContractName())
                        .replaceAll("#sumInvoiceTaxMny#", df.format(invoiceMny))
                        .replaceAll("#sumPayMny#", df.format(payWarnVO.getSumPayMny()))
                        .replaceAll("#percent#", String.valueOf((param.getValue() * 100d)))
                        .replaceAll("#overMny#", df.format(overMny))
        );
        return vo;
    }
    private BigDecimal getBigDecimal(Object obj){
        return null == obj ? BigDecimal.ZERO : new BigDecimal(obj.toString());
    }

}
