package com.ejianc.business.rmat.controller;


import com.ejianc.business.rmat.service.IRentUseRecordDetailService;
import com.ejianc.business.rmat.vo.RentUseRecordRefVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 设备明细 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-11
 */
@RestController
@RequestMapping("rentUseRecordDetail")
public class RentUseRecordDetailController {
    @Autowired
    private IRentUseRecordDetailService rentUseRecordDetailService;
    /**
     * 根据主键ID查询设备使用记录明细
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/useDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentUseRecordRefVO> useDetail(@RequestParam Long id) {
        RentUseRecordRefVO list = rentUseRecordDetailService.useDetail(id);
        return CommonResponse.success(list);
    }
}
