package com.ejianc.business.rmat.mapper;

import com.ejianc.business.rmat.bean.RentSettlementDetailEntity;
import com.ejianc.business.rmat.vo.RentSettlementVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * <p>
 * 设备明细 Mapper 接口
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@Mapper
public interface RentSettlementDetailMapper extends BaseCrudMapper<RentSettlementDetailEntity> {
    @Select("select count(0) from ejc_rmat_rent_settlement where id != #{id} and contract_id = #{contractId} and settlement_type = 1 and dr = 0")
    Integer queryById(@Param("id") Long id,@Param("contractId") Long contractId);
    @Select("select count(0) from ejc_rmat_rent_settlement where contract_id = #{contractId} and settlement_type = 1 and dr = 0")
    Integer queryByContractId(@Param("contractId") Long contractId);
}
