/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.PurchaseContractEntity;
import com.ejianc.business.rmat.service.IPurchaseContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseContract")
public class PurchaseContractBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IPurchaseContractService purchaseContractService;

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(billId));
            Long conorgid = contractEntity.getOrgId();
            CommonResponse conResp = this.orgApi.getOneById(conorgid);
            if (!conResp.isSuccess() || !conResp.isSuccess()) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            Long currentOrg = InvocationInfoProxy.getOrgId();
            String innerCode = ((OrgVO)conResp.getData()).getInnerCode();
            if ("2".equals(contractEntity.getPurchaseType()) && !innerCode.contains(String.valueOf(currentOrg))) {
                return CommonResponse.error((String)("\u5f53\u524d\u96c6\u91c7\u5408\u540c\u7f16\u5236\u7ec4\u7ec7\u662f\u3010" + contractEntity.getOrgName() + "\u3011\uff0c\u4e0d\u53ef\u64a4\u56de\uff01"));
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }
}

