/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.ParamsCheckDsVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.rmat.bean.RentContractEntity;
import com.ejianc.business.rmat.bean.RentSettlementDetailEntity;
import com.ejianc.business.rmat.bean.RentSettlementEntity;
import com.ejianc.business.rmat.bean.RentSettlementFeeEntity;
import com.ejianc.business.rmat.mapper.RentSettlementDetailMapper;
import com.ejianc.business.rmat.mapper.RentSettlementMapper;
import com.ejianc.business.rmat.service.IRentContractDetailService;
import com.ejianc.business.rmat.service.IRentContractService;
import com.ejianc.business.rmat.service.IRentSettlementDetailService;
import com.ejianc.business.rmat.service.IRentSettlementFeeService;
import com.ejianc.business.rmat.service.IRentSettlementService;
import com.ejianc.business.rmat.vo.RentSettlementRecordVO;
import com.ejianc.business.rmat.vo.RentSettlementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="RentSettlementService")
public class RentSettlementServiceImpl
extends BaseServiceImpl<RentSettlementMapper, RentSettlementEntity>
implements IRentSettlementService {
    private static final String RENT_SETTLEMENT_BILL_CODE = "QDSZ_RMAT_RENT_SETTLEMENT";
    private static final String RMAT_RENT_SETTLE = "RMAT_RENT_SETTLE";
    private static final String RMAT_RENT_SETTLE_DETAIL = "RMAT_RENT_SETTLE_DETAIL";
    private static final String RMAT_RENT_SETTLE_FEE = "RMAT_RENT_SETTLE_FEE";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CHECK_PARAM_CODE = "P-5kO0W220";
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private IRentSettlementDetailService rentSettlementDetailService;
    @Autowired
    private IRentSettlementFeeService rentSettlementFeeService;
    @Autowired
    private RentSettlementDetailMapper rentSettlementDetailMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private RentSettlementMapper rentSettlementMapper;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<RentSettlementVO> saveOrUpdate(RentSettlementVO rentSettlementVo) {
        BigDecimal syMny;
        block23: {
            if (rentSettlementVo.getContractVersion() != null && rentSettlementVo.getContractVersion() != 0) {
                Jedis jedis = this.jedisPool.getResource();
                boolean locked = false;
                try {
                    locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(rentSettlementVo.getContractId()), (String)"saveOrUpdate", (int)1000);
                    this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                    if (locked) {
                        Integer conVersion;
                        RentContractEntity contractEntity = (RentContractEntity)((Object)this.rentContractService.selectById(rentSettlementVo.getContractId()));
                        Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                        if (!version.equals(conVersion = rentSettlementVo.getContractVersion())) {
                            CommonResponse commonResponse = CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                            return commonResponse;
                        }
                        break block23;
                    }
                    CommonResponse contractEntity = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                    return contractEntity;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (locked) {
                        RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(rentSettlementVo.getContractId()), (String)"saveOrUpdate");
                    }
                    jedis.close();
                }
            }
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentSettlementEntity entity = null;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(RentSettlementEntity::getContractId, (Object)rentSettlementVo.getContractId());
        lambdachange.eq(RentSettlementEntity::getOrgId, (Object)rentSettlementVo.getOrgId());
        if (null != rentSettlementVo.getId() && rentSettlementVo.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)rentSettlementVo.getId());
        }
        lambdachange.ne(RentSettlementEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(RentSettlementEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355!");
        }
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange2.eq(RentSettlementEntity::getContractId, (Object)rentSettlementVo.getContractId());
        lambdachange2.eq(RentSettlementEntity::getOrgId, (Object)rentSettlementVo.getOrgId());
        if (null != rentSettlementVo.getId() && rentSettlementVo.getId() > 0L) {
            lambdachange2.ne(BaseEntity::getId, (Object)rentSettlementVo.getId());
        }
        lambdachange2.in(RentSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambdachange2.gt(RentSettlementEntity::getSettlementDate, (Object)rentSettlementVo.getSettlementDate());
        int num2 = super.count((Wrapper)lambdachange2);
        if (num2 > 0) {
            throw new BusinessException("\u7ed3\u7b97\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8be5\u5408\u540c\u5bf9\u5e94\u6700\u65b0\u7ed3\u7b97\u65e5\u671f!");
        }
        BigDecimal settlementTaxMny = rentSettlementVo.getSettlementTaxMny() == null ? BigDecimal.ZERO : rentSettlementVo.getSettlementTaxMny();
        BigDecimal offsetMny = rentSettlementVo.getOffsetMny() == null ? BigDecimal.ZERO : rentSettlementVo.getOffsetMny();
        BigDecimal bigDecimal = syMny = rentSettlementVo.getSymny() == null ? BigDecimal.ZERO : rentSettlementVo.getSymny();
        if (offsetMny.compareTo(syMny) > 0) {
            throw new BusinessException("\u672c\u6b21\u51b2\u62b5\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u53ef\u51b2\u62b5\u91d1\u989d!");
        }
        if (offsetMny.compareTo(settlementTaxMny) > 0) {
            throw new BusinessException("\u672c\u6b21\u51b2\u62b5\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u672c\u671f\u7ed3\u7b97\u91d1\u989d");
        }
        if (StringUtils.isEmpty((CharSequence)rentSettlementVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RENT_SETTLEMENT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                rentSettlementVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper queryWrapperDetail = Wrappers.lambdaQuery();
        queryWrapperDetail.eq(RentSettlementDetailEntity::getSettlementId, (Object)rentSettlementVo.getId());
        List detailList = this.rentSettlementDetailService.list((Wrapper)queryWrapperDetail);
        ArrayList<Long> useOldIdList = new ArrayList<Long>();
        if (detailList != null && detailList.size() > 0) {
            for (RentSettlementDetailEntity rentSettlementDetailEntity : detailList) {
                if (rentSettlementDetailEntity.getSource() != 3) continue;
                useOldIdList.add(rentSettlementDetailEntity.getUseId());
            }
        }
        rentSettlementVo.setRelationFlag("0");
        rentSettlementVo.setProportionFlag("0");
        entity = (RentSettlementEntity)((Object)BeanMapper.map((Object)rentSettlementVo, RentSettlementEntity.class));
        super.saveOrUpdate((Object)entity, false);
        List<RentSettlementDetailEntity> rentdetail = entity.getRentdetail();
        if (rentdetail != null && rentdetail.size() > 0) {
            ArrayList<Long> useIds = new ArrayList<Long>();
            for (RentSettlementDetailEntity rentSettlementDetailEntity : rentdetail) {
                if (rentSettlementDetailEntity.getSource() != 3) continue;
                useIds.add(rentSettlementDetailEntity.getUseId());
            }
        }
        RentSettlementVO vo = (RentSettlementVO)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class);
        BigDecimal sumPrePayMny = entity.getSumPrepayMny() == null ? BigDecimal.ZERO : entity.getSumPrepayMny();
        BigDecimal sumOffsetMny = entity.getSumOffsetMny() == null ? BigDecimal.ZERO : entity.getSumOffsetMny();
        vo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return CommonResponse.success((Object)vo);
    }

    @Override
    public RentSettlementVO queryDetail(Long id) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)super.selectById((Serializable)id));
        RentSettlementVO rentSettlementVo = (RentSettlementVO)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class);
        BigDecimal sumPrePayMny = entity.getSumPrepayMny() == null ? BigDecimal.ZERO : entity.getSumPrepayMny();
        BigDecimal sumOffsetMny = entity.getSumOffsetMny() == null ? BigDecimal.ZERO : entity.getSumOffsetMny();
        rentSettlementVo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return rentSettlementVo;
    }

    @Override
    public RentSettlementVO queryDetails(Long id) {
        BigDecimal sumOffsetMnys;
        RentContractEntity entity = (RentContractEntity)((Object)this.rentContractService.selectById(id));
        RentSettlementVO rentSettlementVO = (RentSettlementVO)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class);
        rentSettlementVO.setContractId(rentSettlementVO.getId());
        rentSettlementVO.setId(null);
        rentSettlementVO.setBillCode(null);
        rentSettlementVO.setBillState(null);
        rentSettlementVO.setCreateUserCode(null);
        rentSettlementVO.setCreateTime(null);
        rentSettlementVO.setSettlementDate(new Date());
        rentSettlementVO.setUpdateUserCode(null);
        rentSettlementVO.setUpdateTime(null);
        rentSettlementVO.setRentdetail(null);
        rentSettlementVO.setRentfee(null);
        rentSettlementVO.setTaxMny(BigDecimal.ZERO);
        rentSettlementVO.setSettlementType(Integer.valueOf(0));
        CommonResponse sumPayMnyVO = this.payContractApi.getSumPayMny(id, entity.getOrgId());
        if (!sumPayMnyVO.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\uff01");
        }
        BigDecimal sumPayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPayMny();
        BigDecimal sumPrePayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPrePayMny();
        rentSettlementVO.setSumPayMny(sumPayMny == null ? BigDecimal.ZERO : sumPayMny);
        rentSettlementVO.setSumPrepayMny(sumPrePayMny == null ? BigDecimal.ZERO : sumPrePayMny);
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdachange.eq(RentSettlementEntity::getContractId, (Object)id);
        lambdachange.eq(RentSettlementEntity::getOrgId, (Object)entity.getOrgId());
        lambdachange.in(RentSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal[] settlementMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4)};
            list.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny() == null ? BigDecimal.ZERO : e.getSettlementTaxMny());
                settlementMoney[1] = settlementMoney[1].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
            });
            rentSettlementVO.setSumSettlementTaxMny(settlementMoney[0]);
            rentSettlementVO.setSumOffsetMny(settlementMoney[1]);
        }
        BigDecimal bigDecimal = sumOffsetMnys = rentSettlementVO.getSumOffsetMny() == null ? BigDecimal.ZERO : rentSettlementVO.getSumOffsetMny();
        if (rentSettlementVO.getSumPrepayMny().compareTo(BigDecimal.ZERO) >= 0 && sumOffsetMnys.compareTo(BigDecimal.ZERO) >= 0) {
            rentSettlementVO.setSymny(rentSettlementVO.getSumPrepayMny().subtract(sumOffsetMnys));
        }
        return rentSettlementVO;
    }

    @Override
    public void deleteRentSettlement(List<RentSettlementVO> vos) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (RentSettlementVO rentSettlementVO : vos) {
            ids.add(rentSettlementVO.getId());
        }
        if (ids != null && ids.size() > 0) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(RentSettlementDetailEntity::getSettlementId, ids);
            List rentSettlementDetailEntities = this.rentSettlementDetailService.list((Wrapper)lambda);
            if (rentSettlementDetailEntities != null && rentSettlementDetailEntities.size() > 0) {
                ArrayList<Long> useIds = new ArrayList<Long>();
                for (RentSettlementDetailEntity rentSettlementDetailEntity : rentSettlementDetailEntities) {
                    if (rentSettlementDetailEntity.getSource() != 3) continue;
                    useIds.add(rentSettlementDetailEntity.getUseId());
                }
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public CommonResponse<RentSettlementVO> pushCost(RentSettlementVO rentSettlementVo) {
        RentSettlementEntity rentSettlementEntity = (RentSettlementEntity)((Object)((RentSettlementMapper)this.baseMapper).selectById(rentSettlementVo.getId()));
        if (ListUtil.isNotEmpty((List)rentSettlementVo.getRentdetail())) {
            List rentSettleDetail = BeanMapper.mapList((Iterable)rentSettlementVo.getRentdetail(), RentSettlementDetailEntity.class);
            rentSettlementEntity.setRentdetail(rentSettleDetail);
        }
        if (ListUtil.isNotEmpty((List)rentSettlementVo.getRentfee())) {
            List rentSettleFee = BeanMapper.mapList((Iterable)rentSettlementVo.getRentfee(), RentSettlementFeeEntity.class);
            rentSettlementEntity.setRentfee(rentSettleFee);
        }
        super.saveOrUpdate((Object)rentSettlementEntity, false);
        this.costPush(rentSettlementEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)rentSettlementEntity), RentSettlementVO.class));
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{id});
        updateWrapper.set(RentSettlementEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public RentSettlementRecordVO querySettlementRecord(Long id) {
        RentSettlementRecordVO vo = new RentSettlementRecordVO();
        RentContractEntity entity = (RentContractEntity)((Object)this.rentContractService.selectById(id));
        BigDecimal contractTaxMny = entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny();
        vo.setContractTaxMny(contractTaxMny);
        vo.setContractId(id);
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(RentSettlementEntity::getContractId, (Object)id);
        lambda.in(RentSettlementEntity::getOrgId, commonOrgIds);
        lambda.in(RentSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            BigDecimal sumSettlementTaxMny;
            BigDecimal[] settlementMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4)};
            entities.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny() == null ? BigDecimal.ZERO : e.getSettlementTaxMny());
            });
            vo.setSumSettlementTaxMny(settlementMoney[0]);
            BigDecimal bigDecimal = sumSettlementTaxMny = vo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getSumSettlementTaxMny();
            if (sumSettlementTaxMny.compareTo(BigDecimal.ZERO) > 0 && contractTaxMny.compareTo(BigDecimal.ZERO) > 0) {
                vo.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny, 8, 5)));
            } else {
                vo.setSumScale(BigDecimal.ZERO);
            }
            vo.setSettlementRecord(BeanMapper.mapList((Iterable)entities, RentSettlementVO.class));
        }
        return vo;
    }

    @Override
    public void costPush(RentSettlementEntity settlementEntity) {
        List<RentSettlementFeeEntity> rentfee;
        this.logger.info("\u5f00\u59cbPush");
        List<RentSettlementDetailEntity> rentdetail = settlementEntity.getRentdetail();
        boolean newRelationFlag = true;
        if (ListUtil.isNotEmpty(rentdetail)) {
            for (Object rentSettlementDetailEntity : rentdetail) {
                if (null != rentSettlementDetailEntity.getSubjectId()) continue;
                newRelationFlag = false;
                break;
            }
        }
        if (ListUtil.isNotEmpty(rentfee = settlementEntity.getRentfee()) && newRelationFlag) {
            for (RentSettlementFeeEntity rentSettlementFeeEntity : rentfee) {
                if (null != rentSettlementFeeEntity.getSubjectId()) continue;
                newRelationFlag = false;
                break;
            }
        }
        if (ListUtil.isEmpty(rentdetail) && ListUtil.isEmpty(rentfee)) {
            newRelationFlag = false;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{settlementEntity.getId()});
        updateWrapper.set(RentSettlementEntity::getRelationFlag, (Object)(newRelationFlag ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = settlementEntity.getRelationFlag();
        if (oldRelationFlag.equals("1")) {
            if (newRelationFlag) {
                this.saveCost(settlementEntity);
            }
            if (!newRelationFlag) {
                this.costDetailApi.deleteSubject(settlementEntity.getId());
            }
        }
        if (oldRelationFlag.equals("0") && newRelationFlag) {
            this.saveCost(settlementEntity);
        }
    }

    private void saveCost(RentSettlementEntity settlementEntity) {
        CommonResponse commonResponse;
        List<RentSettlementFeeEntity> pushRentFee;
        BigDecimal taxRate = settlementEntity.getTaxRate().divide(new BigDecimal(100));
        BigDecimal number = taxRate.add(new BigDecimal(1));
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<RentSettlementDetailEntity> pushRentDetail = settlementEntity.getRentdetail();
        if (ListUtil.isNotEmpty(pushRentDetail)) {
            for (RentSettlementDetailEntity rentSettlementDetailEntity : pushRentDetail) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(rentSettlementDetailEntity.getSubjectId());
                costDetailVO.setSourceId(rentSettlementDetailEntity.getSettlementId());
                costDetailVO.setSourceDetailId(rentSettlementDetailEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementDetailEntity.getSettlementMny());
                BigDecimal pushSettlementMny = rentSettlementDetailEntity.getSettlementMny();
                BigDecimal happenMny = pushSettlementMny.divide(number, 2, 4);
                costDetailVO.setHappenMny(happenMny);
                costDetailVO.setHappenDate(settlementEntity.getSettlementDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(RMAT_RENT_SETTLE);
                costDetailVO.setSourceTabType(RMAT_RENT_SETTLE_DETAIL);
                costDetailVO.setProjectId(settlementEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(pushRentFee = settlementEntity.getRentfee())) {
            for (RentSettlementFeeEntity rentSettlementFeeEntity : pushRentFee) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(rentSettlementFeeEntity.getSubjectId());
                costDetailVO.setSourceId(rentSettlementFeeEntity.getSettlementId());
                costDetailVO.setSourceDetailId(rentSettlementFeeEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementFeeEntity.getFeemoney());
                BigDecimal pushSettlementMny = rentSettlementFeeEntity.getFeemoney();
                BigDecimal happenMny = pushSettlementMny.divide(number, 2, 4);
                costDetailVO.setHappenMny(happenMny);
                costDetailVO.setHappenDate(settlementEntity.getSettlementDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(RMAT_RENT_SETTLE);
                costDetailVO.setSourceTabType(RMAT_RENT_SETTLE_FEE);
                costDetailVO.setProjectId(settlementEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList) && !(commonResponse = this.costDetailApi.saveSubject(costDetailVOList)).isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
    }

    @Override
    public ParamsCheckVO checkParams(BigDecimal sumPayMny, BigDecimal payMny, BigDecimal contractMny) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal sumPayWithThisMny = sumPayMny.add(payMny);
            BigDecimal comMny = contractMny.multiply(roleValue.divide(BigDecimal.valueOf(100L)));
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            if (sumPayWithThisMny.compareTo(comMny) > 0) {
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(payMny.toString()).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(sumPayWithThisMny.subtract(comMny)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }

    @Override
    public Integer queryById(Long id, Long contractId) {
        return this.rentSettlementDetailMapper.queryById(id, contractId);
    }

    @Override
    public Integer queryByContractId(Long contractId) {
        return this.rentSettlementDetailMapper.queryByContractId(contractId);
    }
}

